/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.raid.elite;

import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.block.entity.challenge.elite.EliteChallengeManager;
import iskallia.vault.block.entity.challenge.raid.ChallengeActionEntry;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EliteControllerBlockEntity
extends ChallengeControllerBlockEntity<EliteChallengeManager> {
    private BlockCuboid zone;
    private final Map<List<BlockPos>, List<ChallengeActionEntry>> proxies;
    private final WeightedList<PartialEntity> elite;
    public static ArrayAdapter<ChallengeActionEntry> ENTRIES = Adapters.ofArray(ChallengeActionEntry[]::new, Adapters.of(ChallengeActionEntry::new, false));

    public EliteControllerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ELITE_CONTROLLER_TILE_ENTITY, pos, state);
        this.setRenderer(4351733, 4351733, 4351733);
        this.proxies = new LinkedHashMap<List<BlockPos>, List<ChallengeActionEntry>>();
        this.zone = null;
        this.elite = new WeightedList();
    }

    @Override
    public EliteChallengeManager createManager() {
        ChunkRandom random = ChunkRandom.any();
        random.setDecoratorSeed(ServerVaults.get(this.f_58857_).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.m_58899_().m_123341_(), this.m_58899_().m_123343_(), 329045113);
        EliteChallengeManager manager = new EliteChallengeManager(this.uuid, (ResourceKey<Level>)this.f_58857_.m_46472_(), this.m_58899_());
        manager.setZone(this.zone.rotate(this.getRotation(), BlockPos.f_121853_, true).offset((Vec3i)this.m_58899_()));
        this.proxies.forEach((offsets, entries) -> {
            for (BlockPos offset : offsets) {
                RotateTileProcessor processor = new RotateTileProcessor(this.getRotation(), 0, 0, true);
                offset = processor.transform(offset);
                manager.getProxies().put(offset, new EliteChallengeManager.Proxy((List<ChallengeActionEntry>)entries, this.elite.getRandom(random).orElseGet(() -> PartialEntity.parse("minecraft:pig", true).orElseThrow())));
            }
        });
        return manager;
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.BLOCK_CUBOID.writeNbt(this.zone).ifPresent(tag -> nbt.m_128365_("zone", tag));
        ListTag proxies = new ListTag();
        this.proxies.forEach((pos, entries) -> {
            CompoundTag entry = new CompoundTag();
            if (pos.size() == 1) {
                Adapters.BLOCK_POS.writeNbt((BlockPos)pos.get(0)).ifPresent(tag -> entry.m_128365_("pos", tag));
            } else {
                ListTag positions = new ListTag();
                for (BlockPos p : pos) {
                    Adapters.BLOCK_POS.writeNbt(p).ifPresent(arg_0 -> positions.add(arg_0));
                }
                entry.m_128365_("pos", (Tag)positions);
            }
            ENTRIES.writeNbt((ChallengeActionEntry)((ChallengeActionEntry[])entries.toArray(ChallengeActionEntry[]::new))).ifPresent(tag -> entry.m_128365_("entries", tag));
            proxies.add((Object)entry);
        });
        nbt.m_128365_("proxies", (Tag)proxies);
        ListTag boss = new ListTag();
        this.elite.forEach((entity, weight) -> Adapters.PARTIAL_ENTITY.writeNbt((PartialEntity)entity).ifPresent(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                Adapters.DOUBLE.writeNbt(weight).ifPresent(tag1 -> compound.m_128365_("weight", tag1));
                boss.add(tag);
            }
        }));
        nbt.m_128365_("elite", (Tag)boss);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.zone = Adapters.BLOCK_CUBOID.readNbt(nbt.m_128423_("zone")).orElse(null);
        ListTag proxies = nbt.m_128437_("proxies", 10);
        this.proxies.clear();
        for (int i = 0; i < proxies.size(); ++i) {
            ListTag list;
            CompoundTag entry = proxies.m_128728_(i);
            ArrayList positions = new ArrayList();
            Tag tag = entry.m_128423_("pos");
            if (tag instanceof ListTag && ((list = (ListTag)tag).m_7264_() == 9 || list.m_7264_() == 4)) {
                for (Tag tag2 : list) {
                    Adapters.BLOCK_POS.readNbt(tag2).ifPresent(positions::add);
                }
            } else {
                Adapters.BLOCK_POS.readNbt(entry.m_128423_("pos")).ifPresent(positions::add);
            }
            this.proxies.put(positions, Arrays.stream((ChallengeActionEntry[])ENTRIES.readNbt(entry.m_128423_("entries")).orElseThrow()).collect(Collectors.toList()));
        }
        ListTag boss = nbt.m_128437_("elite", 10);
        this.elite.clear();
        for (int i = 0; i < boss.size(); ++i) {
            double weight = Adapters.DOUBLE.readNbt(boss.m_128728_(i).m_128423_("weight")).orElse(1.0);
            Adapters.PARTIAL_ENTITY.readNbt((Tag)boss.m_128728_(i)).ifPresent(entity -> this.elite.put((PartialEntity)entity, weight));
        }
    }
}

