/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.xmark;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.MirrorTileProcessor;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.processor.tile.TranslateTileProcessor;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.mixin.AccessorChunkMap;
import iskallia.vault.world.data.ServerVaults;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.mutable.MutableObject;

public class XMarkAnimation {
    private State state = State.IDLE;
    private int ticker;

    public State getState() {
        return this.state;
    }

    public void onStart(State state) {
        this.state = state;
        this.ticker = 0;
    }

    public void onStop() {
        this.state = State.IDLE;
        this.ticker = 0;
    }

    public boolean isCompleted() {
        return this.ticker >= this.state.getTime();
    }

    public void onTick(ServerLevel world, BlockPos pos) {
        if (this.state == State.OPEN_ROOM_TRAP) {
            BlockPos offset = new BlockPos(0, -1, 0);
            Template template = null;
            if (this.ticker % 5 == 0 && this.ticker / 5 <= 6) {
                world.m_5594_(null, pos.m_141952_((Vec3i)offset), SoundEvents.f_11711_, SoundSource.BLOCKS, 1.4f, 1.0f);
                template = (Template)VaultRegistry.TEMPLATE.getKey(VaultMod.id("vault/animations/x-mark1/trapped" + this.ticker / 5)).get(Version.latest());
            }
            if (template != null) {
                this.place(world, template, pos, settings -> {
                    settings.addProcessor(TileProcessor.translate(-5, 0, -5));
                    settings.addProcessor(TileProcessor.translate((Vec3i)pos));
                    settings.addProcessor(TileProcessor.translate((Vec3i)offset));
                });
            }
        } else if (this.state == State.OPEN_ROOM_LOOT) {
            BlockPos offset = new BlockPos(0, -1, 0);
            Template template = null;
            if (this.ticker % 5 == 0 && this.ticker / 5 <= 6) {
                world.m_5594_(null, pos.m_141952_((Vec3i)offset), SoundEvents.f_11711_, SoundSource.BLOCKS, 1.4f, 1.0f);
                template = (Template)VaultRegistry.TEMPLATE.getKey(VaultMod.id("vault/animations/x-mark1/treasure" + this.ticker / 5)).get(Version.latest());
            }
            if (template != null) {
                this.place(world, template, pos, settings -> {
                    settings.addProcessor(TileProcessor.translate(-5, 0, -5));
                    settings.addProcessor(TileProcessor.translate((Vec3i)pos));
                    settings.addProcessor(TileProcessor.translate((Vec3i)offset));
                });
            }
        } else if (this.state == State.CLOSE_ROOF) {
            for (int dx = -3; dx <= 3; ++dx) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos p = pos.m_142082_(dx, 4, dz);
                    BlockState state = world.m_8055_(p);
                    if (state.m_60838_((BlockGetter)world, pos)) continue;
                    IZonedWorld.runWithBypass(world, true, () -> world.m_7731_(p, ModBlocks.VAULT_BEDROCK.m_49966_(), 3));
                }
            }
        } else if (this.state == State.OPEN_ROOF) {
            for (int dx = -3; dx <= 3; ++dx) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos p = pos.m_142082_(dx, 4, dz);
                    BlockState state = world.m_8055_(p);
                    if (state.m_60734_() != ModBlocks.VAULT_BEDROCK) continue;
                    IZonedWorld.runWithBypass(world, true, () -> world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3));
                }
            }
        }
        ++this.ticker;
    }

    public void place(ServerLevel world, Template template, BlockPos pos, Consumer<PlacementSettings> configurator) {
        VaultGenerator vaultGenerator;
        ChunkRandom random = ChunkRandom.any();
        random.setRegionSeed(0L, pos.m_123341_(), pos.m_123343_(), 32573453L);
        Vault vault = ServerVaults.get((Level)world).orElse(null);
        if (vault != null) {
            VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
            RegionPos region = RegionPos.of(pos.m_123341_(), pos.m_123343_(), generator.get(GridGenerator.CELL_X), generator.get(GridGenerator.CELL_Z));
            random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 32573453L);
        }
        PlacementSettings settings = new PlacementSettings(new ProcessorContext(null, random)).setFlags(3);
        if (vault != null && (vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR)) instanceof GridGenerator) {
            GridGenerator gen = (GridGenerator)vaultGenerator;
            RegionPos region = RegionPos.ofBlockPos(pos, gen.get(GridGenerator.CELL_X), gen.get(GridGenerator.CELL_Z));
            ChunkRandom chunkRandom = ChunkRandom.any();
            chunkRandom.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
            JigsawTemplate room = (JigsawTemplate)gen.get(GridGenerator.LAYOUT).getAt(vault, region, chunkRandom, settings);
            room.getConfigurator().accept(settings);
            settings.getTileProcessors().removeIf(processor -> processor instanceof TranslateTileProcessor);
            settings.getTileProcessors().removeIf(processor -> processor instanceof MirrorTileProcessor);
            settings.getTileProcessors().removeIf(processor -> processor instanceof RotateTileProcessor);
            settings.resetTileMapper();
            configurator.accept(settings);
        }
        AtomicReference<Object> pointer = new AtomicReference<Object>(null);
        settings.addProcessor(TileProcessor.of((_tile, context) -> {
            pointer.getAndUpdate(value -> {
                if (value == null) {
                    return BoundingBox.m_162375_((Vec3i)_tile.getPos(), (Vec3i)_tile.getPos());
                }
                return value.m_162371_(_tile.getPos());
            });
            return _tile;
        }));
        IZonedWorld.runWithBypass(world, true, () -> template.place((ServerLevelAccessor)world, settings));
        BoundingBox box = pointer.get();
        if (box == null) {
            return;
        }
        ServerChunkCache source = world.m_7726_();
        for (int x = box.m_162395_(); x < box.m_162399_(); x += x + 16 < box.m_162399_() ? 16 : 16 - Math.floorMod(x, 16)) {
            for (int z = box.m_162398_(); z < box.m_162401_(); z += z + 16 < box.m_162401_() ? 16 : 16 - Math.floorMod(z, 16)) {
                ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
                world.m_142572_().m_6937_((Runnable)new TickTask(world.m_142572_().m_129921_() + 1, () -> source.f_8325_.m_183262_(chunkPos, false).forEach(player -> {
                    world.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
                    ((AccessorChunkMap)source.f_8325_).callUpdateChunkTracking((ServerPlayer)player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                })));
            }
        }
    }

    public static enum State {
        IDLE(0),
        CLOSE_ROOF(1),
        OPEN_ROOM_TRAP(40),
        OPEN_ROOM_LOOT(40),
        FIGHT(0),
        OPEN_ROOF(1);

        private final int time;

        private State(int time) {
            this.time = time;
        }

        public int getTime() {
            return this.time;
        }
    }
}

