/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.xmark;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.xmark.XMarkAnimation;
import iskallia.vault.block.entity.challenge.xmark.XMarkSpawner;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.core.world.storage.WorldZone;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.AbsorbingParticleMessage;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldZonesData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class XMarkChallengeManager
extends ChallengeManager {
    private int zoneId;
    private BlockCuboid zone;
    private double trapChance;
    private final XMarkSpawner spawner;
    private final XMarkAnimation animation;
    private final List<ChallengeAction<?>> actions;
    private final List<ChallengeAction<?>> scheduledActions;
    public static ArrayAdapter<ChallengeAction<?>> ACTIONS = Adapters.ofArray(ChallengeAction[]::new, Adapters.CHALLENGE_ACTION);
    public static final ResourceLocation HUD = VaultMod.id("textures/gui/challenge/x-mark/hud.png");

    public XMarkChallengeManager() {
        this.spawner = new XMarkSpawner();
        this.animation = new XMarkAnimation();
        this.actions = new ArrayList();
        this.scheduledActions = new ArrayList();
    }

    public XMarkChallengeManager(UUID uuid, ResourceKey<Level> dimension, BlockPos pos) {
        super(uuid, dimension, pos);
        this.zoneId = -1;
        this.spawner = new XMarkSpawner();
        this.animation = new XMarkAnimation();
        this.actions = new ArrayList();
        this.scheduledActions = new ArrayList();
    }

    public BlockCuboid getZone() {
        return this.zone;
    }

    public void setZone(BlockCuboid zone) {
        this.zone = zone;
    }

    public void setTrapChance(double trapChance) {
        this.trapChance = trapChance;
    }

    public void addActions(List<ChallengeAction<?>> actions) {
        this.scheduledActions.addAll(actions);
    }

    public XMarkSpawner getSpawner() {
        return this.spawner;
    }

    @Override
    public void onAttach(ServerLevel world) {
        super.onAttach(world);
        this.spawner.onAttach((Level)world, this);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.spawner.onDetach();
    }

    @Override
    public void onTick(ServerLevel world) {
        ChallengeControllerBlockEntity controller;
        if (this.isDeleted()) {
            return;
        }
        this.refreshPlayers(world);
        if (this.players.isEmpty() && this.zoneId >= 0) {
            this.spawner.setActive(false);
            WorldZonesData.get(world.m_142572_()).getOrCreate((ResourceKey<Level>)this.dimension).remove(this.zoneId);
            this.setDeleted(true);
            return;
        }
        ChunkRandom random = ChunkRandom.any();
        random.setDecoratorSeed(ServerVaults.get((Level)world).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.pos.m_123341_(), this.pos.m_123343_(), 329057345);
        BlockEntity blockEntity = this.getBlockEntity(world.m_142572_());
        if (blockEntity instanceof ChallengeControllerBlockEntity && (controller = (ChallengeControllerBlockEntity)blockEntity).getState() == ChallengeControllerBlockEntity.State.ACTIVE && this.animation.getState() == XMarkAnimation.State.IDLE) {
            if (random.nextDouble() < this.trapChance) {
                if (this.zoneId < 0 && this.zone != null) {
                    this.zoneId = WorldZonesData.get(world.m_142572_()).getOrCreate((ResourceKey<Level>)world.m_46472_()).add(new WorldZone().add(this.zone.offset((Vec3i)this.pos)).setModify(false));
                }
                this.animation.onStart(XMarkAnimation.State.CLOSE_ROOF);
            } else {
                this.animation.onStart(XMarkAnimation.State.OPEN_ROOM_LOOT);
            }
        }
        if (this.animation.getState() == XMarkAnimation.State.CLOSE_ROOF && this.animation.isCompleted()) {
            this.animation.onStart(XMarkAnimation.State.OPEN_ROOM_TRAP);
        }
        if (this.animation.getState() == XMarkAnimation.State.OPEN_ROOM_TRAP && this.animation.isCompleted()) {
            this.animation.onStart(XMarkAnimation.State.FIGHT);
            this.spawner.setActive(true);
        }
        this.spawner.onTick(world, this.pos, this.players);
        if (this.animation.getState() == XMarkAnimation.State.FIGHT && this.spawner.isWaveCompleted() && this.zoneId >= 0) {
            this.spawner.setActive(false);
            this.animation.onStart(XMarkAnimation.State.OPEN_ROOF);
            WorldZonesData.get(world.m_142572_()).getOrCreate((ResourceKey<Level>)this.dimension).remove(this.zoneId);
        }
        if ((this.animation.getState() == XMarkAnimation.State.OPEN_ROOM_LOOT || this.animation.getState() == XMarkAnimation.State.OPEN_ROOF) && this.animation.isCompleted()) {
            this.computeScheduledActions(world, random);
            this.setDeleted(true);
        }
        this.animation.onTick(world, this.pos);
    }

    public void computeScheduledActions(ServerLevel world, RandomSource random) {
        int vaultLevel = VaultUtils.getVault((Level)world).map(vault -> vault.get(Vault.LEVEL).get()).orElse(this.getHighestVaultLevel(world));
        List<ChallengeAction<?>> merged = ChallengeAction.merge(this.scheduledActions.stream().map(action -> {
            action = action.copy();
            action.onPopulate(random);
            return action;
        }).flatMap(action -> action.flatten(random, vaultLevel)).peek(action -> {
            action.onPopulate(random);
            action.onActivate(world, this, random);
        }).collect(Collectors.toList()));
        ChallengeAction.merge(this.actions, merged);
        this.scheduledActions.clear();
    }

    public void refreshPlayers(ServerLevel world) {
        HashSet<ServerPlayer> toRemove = new HashSet<ServerPlayer>();
        for (UUID uuid : this.players) {
            ServerPlayer player = world.m_142572_().m_6846_().m_11259_(uuid);
            if (player == null || player.f_19853_ == world && this.zone.offset((Vec3i)this.pos).grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
            toRemove.add(player);
        }
        for (ServerPlayer player : toRemove) {
            this.removePlayer((Player)player);
        }
        for (ServerPlayer player : world.m_6907_()) {
            if (!this.zone.offset((Vec3i)this.pos).grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
            this.addPlayer((Player)player);
        }
    }

    @Override
    public void onRemove(MinecraftServer server) {
        BlockEntity blockEntity;
        if (this.zoneId >= 0) {
            WorldZonesData.get(server).getOrCreate((ResourceKey<Level>)this.dimension).remove(this.zoneId);
        }
        if ((blockEntity = this.getBlockEntity(server)) instanceof ChallengeControllerBlockEntity) {
            ChallengeControllerBlockEntity controller = (ChallengeControllerBlockEntity)blockEntity;
            controller.setState(ChallengeControllerBlockEntity.State.DESTROYED);
            controller.m_58904_().m_5594_(null, controller.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
            controller.m_58904_().m_5594_(null, controller.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 2.0f);
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AbsorbingParticleMessage(new Vec3((double)controller.m_58899_().m_123341_(), (double)controller.m_58899_().m_123342_() + 1.65, (double)controller.m_58899_().m_123343_()), new Vec3((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.65, (double)this.pos.m_123343_() + 0.5), controller.getRenderer().getParticleColor()));
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.BLOCK_CUBOID.writeNbt(this.zone).ifPresent(tag -> nbt.m_128365_("zone", tag));
            Adapters.INT.writeNbt(this.zoneId).ifPresent(tag -> nbt.m_128365_("zoneId", tag));
            Adapters.DOUBLE.writeNbt(this.trapChance).ifPresent(tag -> nbt.m_128365_("trapChance", tag));
            this.spawner.writeNbt().ifPresent(tag -> nbt.m_128365_("spawner", (Tag)tag));
            ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.actions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("actions", tag));
            ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.scheduledActions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("scheduledActions", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.zone = Adapters.BLOCK_CUBOID.readNbt(nbt.m_128423_("zone")).orElse(null);
        this.zoneId = Adapters.INT.readNbt(nbt.m_128423_("zoneId")).orElse(-1);
        this.trapChance = Adapters.DOUBLE.readNbt(nbt.m_128423_("trapChance")).orElse(0.0);
        this.spawner.readNbt(nbt.m_128469_("spawner"));
        this.actions.clear();
        ACTIONS.readNbt(nbt.m_128423_("actions")).ifPresent(actions -> this.actions.addAll(Arrays.asList(actions)));
        this.scheduledActions.clear();
        ACTIONS.readNbt(nbt.m_128423_("scheduledActions")).ifPresent(actions -> this.scheduledActions.addAll(Arrays.asList(actions)));
    }

    @Override
    public boolean shouldRenderObjectives() {
        return this.spawner.isWaveCompleted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(PoseStack matrixStack, float partialTicks, Window window) {
        if (this.spawner.isWaveCompleted()) {
            return;
        }
        TextComponent txt = new TextComponent("Clear all Mobs");
        int midX = window.m_85445_() / 2;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
        double progress = this.spawner.getCurrentHealth() / this.spawner.getTotalHealth();
        matrixStack.m_85837_((double)(midX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)50);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)28.0f, (int)(15 + (int)(130.0 * progress)), (int)10, (int)200, (int)50);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        FormattedCharSequence formattedCharSequence = txt.m_7532_();
        float f = (float)midX / 0.6f - (float)font.m_92852_((FormattedText)txt) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, (float)(9 + 22), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
    }
}

