/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.xmark;

import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.block.entity.challenge.raid.action.ChallengeAction;
import iskallia.vault.block.entity.challenge.xmark.XMarkChallengeManager;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class XMarkControllerBlockEntity
extends ChallengeControllerBlockEntity<XMarkChallengeManager> {
    private BlockCuboid zone;
    private final List<BlockPos> spawners;
    private double trapChance;
    private IntRoll waves;
    private int spawnDelay;
    private final List<ChallengeAction<?>> actions;
    public static ArrayAdapter<ChallengeAction<?>> ACTIONS = Adapters.ofArray(ChallengeAction[]::new, Adapters.CHALLENGE_ACTION);

    public XMarkControllerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.X_MARK_CONTROLLER_TILE_ENTITY, pos, state);
        this.setRenderer(9470726, 9470726, 9470726);
        this.zone = null;
        this.spawners = new ArrayList<BlockPos>();
        this.trapChance = 0.5;
        this.waves = IntRoll.ofConstant(2);
        this.spawnDelay = 100;
        this.actions = new ArrayList();
    }

    @Override
    public XMarkChallengeManager createManager() {
        ChunkRandom random = ChunkRandom.any();
        random.setDecoratorSeed(ServerVaults.get(this.f_58857_).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.m_58899_().m_123341_(), this.m_58899_().m_123343_(), 329045113);
        XMarkChallengeManager manager = new XMarkChallengeManager(this.uuid, (ResourceKey<Level>)this.f_58857_.m_46472_(), this.m_58899_());
        manager.setZone(this.zone);
        manager.setTrapChance(this.trapChance);
        manager.getSpawner().add(this.spawners);
        manager.getSpawner().setWaveTarget(this.waves.get(random));
        manager.getSpawner().setSpawnDelay(this.spawnDelay);
        manager.addActions(this.actions);
        return manager;
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.BLOCK_CUBOID.writeNbt(this.zone).ifPresent(tag -> nbt.m_128365_("zone", tag));
        ListTag spawners = new ListTag();
        for (BlockPos spawner : this.spawners) {
            Adapters.BLOCK_POS.writeNbt(spawner).ifPresent(arg_0 -> spawners.add(arg_0));
        }
        nbt.m_128365_("spawners", (Tag)spawners);
        Adapters.DOUBLE.writeNbt(this.trapChance).ifPresent(tag -> nbt.m_128365_("trapChance", tag));
        Adapters.INT_ROLL.writeNbt(this.waves).ifPresent(tag -> nbt.m_128365_("waves", tag));
        Adapters.INT.writeNbt(this.spawnDelay).ifPresent(tag -> nbt.m_128365_("spawnDelay", tag));
        ACTIONS.writeNbt((ChallengeAction<?>)((ChallengeAction[])this.actions.toArray(ChallengeAction[]::new))).ifPresent(tag -> nbt.m_128365_("actions", tag));
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.zone = Adapters.BLOCK_CUBOID.readNbt(nbt.m_128423_("zone")).orElse(null);
        this.spawners.clear();
        Tag tag = nbt.m_128423_("spawners");
        if (tag instanceof ListTag) {
            ListTag spawners = (ListTag)tag;
            for (int i = 0; i < spawners.size(); ++i) {
                Adapters.BLOCK_POS.readNbt(spawners.get(i)).ifPresent(this.spawners::add);
            }
        }
        this.trapChance = Adapters.DOUBLE.readNbt(nbt.m_128423_("trapChance")).orElse(0.0);
        this.waves = Adapters.INT_ROLL.readNbt(nbt.m_128423_("waves")).orElse(IntRoll.ofConstant(2));
        this.spawnDelay = Adapters.INT.readNbt(nbt.m_128423_("spawnDelay")).orElse(100);
        this.actions.clear();
        ACTIONS.readNbt(nbt.m_128423_("actions")).ifPresent(actions -> this.actions.addAll(Arrays.asList(actions)));
    }
}

