/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.challenge.xmark;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.challenge.xmark.XMarkChallengeManager;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.event.CommonEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraftforge.eventbus.api.EventPriority;

public class XMarkSpawner
implements ISerializable<CompoundTag, JsonObject> {
    private final List<BlockPos> blocks = new ArrayList<BlockPos>();
    private final Set<UUID> spawnedWave = new HashSet<UUID>();
    private double currentHealth;
    private double totalHealth;
    private int waveCount;
    private int waveTarget;
    private int spawnDelay;
    private int spawnTick;
    private boolean active;
    private boolean trackSpawns;

    public List<BlockPos> getBlocks() {
        return this.blocks;
    }

    public double getCurrentHealth() {
        return this.currentHealth;
    }

    public double getTotalHealth() {
        return this.totalHealth;
    }

    public void add(List<BlockPos> blocks) {
        this.blocks.addAll(blocks);
    }

    public void setWaveTarget(int waveTarget) {
        this.waveTarget = waveTarget;
    }

    public boolean isWaveCompleted() {
        return this.spawnedWave.isEmpty();
    }

    public int getWaveCount() {
        return this.waveCount;
    }

    public int getWaveTarget() {
        return this.waveTarget;
    }

    public void onCompleteWave() {
        ++this.waveCount;
    }

    public void setSpawnDelay(int spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void onAttach(Level world, XMarkChallengeManager manager) {
        CommonEvents.ENTITY_LEAVE.register((Object)this, EventPriority.HIGHEST, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            this.spawnedWave.remove(event.getEntity().m_142081_());
        });
        CommonEvents.ENTITY_INITIALIZE.register(this, event -> {
            if (!this.trackSpawns || event.getMob().f_19853_ != world) {
                return;
            }
            this.spawnedWave.add(event.getMob().m_142081_());
        });
    }

    public void onDetach() {
        CommonEvents.ENTITY_LEAVE.release(this);
        CommonEvents.ENTITY_INITIALIZE.release(this);
    }

    public void onTick(ServerLevel world, BlockPos pos, Set<UUID> players) {
        this.spawnedWave.removeIf(uuid -> world.m_8791_(uuid) == null);
        if (this.active) {
            if (this.spawnDelay > 0 && this.spawnTick % this.spawnDelay == 0) {
                this.onSpawn(world, pos, players.stream().map(arg_0 -> ((ServerLevel)world).m_46003_(arg_0)).toList());
            }
            ++this.spawnTick;
        }
        double total = 0.0;
        this.currentHealth = 0.0;
        for (UUID uuid2 : this.spawnedWave) {
            Entity entity = world.m_8791_(uuid2);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            this.currentHealth += (double)living.m_21223_();
            total += (double)living.m_21233_();
        }
        if (total > this.totalHealth) {
            this.totalHealth = total;
        }
    }

    public void onSpawn(ServerLevel world, BlockPos pos, List<Player> players) {
        if (this.waveCount >= this.waveTarget) {
            return;
        }
        ++this.waveCount;
        if (this.waveCount == this.waveTarget) {
            players.forEach(player -> world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11937_, SoundSource.MASTER, 0.2f, 0.2f));
        } else {
            players.forEach(player -> world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11874_, SoundSource.MASTER, 0.2f, 0.2f));
        }
        this.totalHealth = 0.0;
        for (BlockPos spawner : this.blocks) {
            EntityBlock entityBlock;
            BlockEntityTicker ticker;
            BlockEntity blockEntity = world.m_7702_(spawner = spawner.m_141952_((Vec3i)pos));
            if (blockEntity == null) {
                return;
            }
            CompoundTag nbt = blockEntity.m_187482_();
            CompoundTag manager = nbt.m_128469_("Manager");
            nbt.m_128365_("Manager", (Tag)manager);
            CompoundTag settings = manager.m_128469_("Settings");
            manager.m_128365_("Settings", (Tag)settings);
            manager.m_128405_("SpawnTimer", 0);
            manager.m_128405_("UsesLeft", 1);
            settings.m_128405_("Mode", 2);
            settings.m_128405_("SpawnDelay", 20000000);
            blockEntity.m_142466_(nbt);
            Block block = world.m_8055_(spawner).m_60734_();
            if (!(block instanceof EntityBlock) || (ticker = (entityBlock = (EntityBlock)block).m_142354_((Level)world, blockEntity.m_58900_(), blockEntity.m_58903_())) == null) continue;
            this.trackSpawns = true;
            ticker.m_155252_((Level)world, blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
            this.trackSpawns = false;
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            ListTag blocks = new ListTag();
            for (BlockPos block : this.blocks) {
                Adapters.BLOCK_POS.writeNbt(block).ifPresent(arg_0 -> blocks.add(arg_0));
            }
            nbt.m_128365_("blocks", (Tag)blocks);
            ListTag spawnedWave = new ListTag();
            for (UUID uuid : this.spawnedWave) {
                spawnedWave.add((Object)StringTag.m_129297_((String)uuid.toString()));
            }
            nbt.m_128365_("spawnedWave", (Tag)spawnedWave);
            Adapters.DOUBLE.writeNbt(this.currentHealth).ifPresent(tag -> nbt.m_128365_("currentHealth", tag));
            Adapters.DOUBLE.writeNbt(this.totalHealth).ifPresent(tag -> nbt.m_128365_("totalHealth", tag));
            Adapters.INT.writeNbt(this.waveCount).ifPresent(tag -> nbt.m_128365_("waveCount", tag));
            Adapters.INT.writeNbt(this.waveTarget).ifPresent(tag -> nbt.m_128365_("waveTarget", tag));
            Adapters.INT.writeNbt(this.spawnDelay).ifPresent(tag -> nbt.m_128365_("spawnDelay", tag));
            Adapters.INT.writeNbt(this.spawnTick).ifPresent(tag -> nbt.m_128365_("spawnTick", tag));
            Adapters.BOOLEAN.writeNbt(this.active).ifPresent(tag -> nbt.m_128365_("active", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        ListTag blocks = nbt.m_128437_("blocks", 10);
        this.blocks.clear();
        for (int i = 0; i < blocks.size(); ++i) {
            Adapters.BLOCK_POS.readNbt(blocks.get(i)).ifPresent(this.blocks::add);
        }
        ListTag spawnedWave = nbt.m_128437_("spawnedWave", 8);
        this.spawnedWave.clear();
        for (int i = 0; i < spawnedWave.size(); ++i) {
            this.spawnedWave.add(UUID.fromString(spawnedWave.m_128778_(i)));
        }
        this.currentHealth = Adapters.DOUBLE.readNbt(nbt.m_128423_("currentHealth")).orElse(0.0);
        this.totalHealth = Adapters.DOUBLE.readNbt(nbt.m_128423_("totalHealth")).orElse(0.0);
        this.waveCount = Adapters.INT.readNbt(nbt.m_128423_("waveCount")).orElse(0);
        this.waveTarget = Adapters.INT.readNbt(nbt.m_128423_("waveTarget")).orElse(0);
        this.spawnDelay = Adapters.INT.readNbt(nbt.m_128423_("spawnDelay")).orElse(0);
        this.spawnTick = Adapters.INT.readNbt(nbt.m_128423_("spawnTick")).orElse(0);
        this.active = Adapters.BOOLEAN.readNbt(nbt.m_128423_("active")).orElse(false);
    }
}

