/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.hologram;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import iskallia.vault.block.entity.hologram.ItemHologramElement;
import iskallia.vault.block.entity.hologram.ModelHologramElement;
import iskallia.vault.block.entity.hologram.RootHologramElement;
import iskallia.vault.block.entity.hologram.TextHologramElement;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class HologramElement
implements ISerializable<CompoundTag, JsonObject> {
    public static final Adapter ADAPTER = new Adapter();
    protected Vec3 translation = Vec3.f_82478_;
    protected Vec3 rotation = Vec3.f_82478_;
    protected Vec3 scale = new Vec3(1.0, 1.0, 1.0);
    protected List<HologramElement> children = new ArrayList<HologramElement>();

    public Vec3 getTranslation() {
        return this.translation;
    }

    public <T extends HologramElement> T setTranslation(Vec3 translation) {
        this.translation = translation;
        return (T)this;
    }

    public Vec3 getEulerRotation() {
        return this.rotation;
    }

    public Quaternion getQuaternionRotation() {
        return this.getQuaternionRotation(this.getEulerRotation());
    }

    public Quaternion getQuaternionRotation(Vec3 eulerRotation) {
        return Quaternion.m_175218_((float)((float)(eulerRotation.f_82480_ * Math.PI / 180.0)), (float)((float)(eulerRotation.f_82479_ * Math.PI / 180.0)), (float)((float)(eulerRotation.f_82481_ * Math.PI / 180.0)));
    }

    public <T extends HologramElement> T setEulerRotation(Vec3 rotation) {
        this.rotation = new Vec3(rotation.f_82479_, Mth.m_14175_((double)rotation.f_82480_), Mth.m_14175_((double)rotation.f_82481_));
        return (T)this;
    }

    public Vec3 getScale() {
        return this.scale;
    }

    public <T extends HologramElement> T setScale(Vec3 scale) {
        this.scale = scale;
        return (T)this;
    }

    public <T extends HologramElement> T setScale(double scale) {
        this.scale = new Vec3(scale, scale, scale);
        return (T)this;
    }

    public List<HologramElement> getChildren() {
        return this.children;
    }

    public <T extends HologramElement> T add(HologramElement ... elements) {
        this.children.addAll(Arrays.asList(elements));
        return (T)this;
    }

    public <T> void iterate(Class<T> type, Consumer<T> runnable) {
        if (type.isAssignableFrom(this.getClass())) {
            runnable.accept(this);
        }
        for (HologramElement child : this.children) {
            child.iterate(type, runnable);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrices, MultiBufferSource bufferSource, float partialTick, int light, int overlay) {
        matrices.m_85836_();
        matrices.m_85837_(this.translation.f_82479_, this.translation.f_82480_, this.translation.f_82481_);
        matrices.m_85845_(this.getQuaternionRotation());
        matrices.m_85841_((float)this.scale.f_82479_, (float)this.scale.f_82480_, (float)this.scale.f_82481_);
        this.renderInternal(matrices, bufferSource, partialTick, light, overlay);
        for (HologramElement child : this.children) {
            child.render(matrices, bufferSource, partialTick, light, overlay);
        }
        matrices.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderInternal(PoseStack matrices, MultiBufferSource bufferSource, float partialTick, int light, int overlay) {
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag translation = new CompoundTag();
        Adapters.DOUBLE.writeNbt(this.translation.f_82479_).ifPresent(tag -> translation.m_128365_("x", tag));
        Adapters.DOUBLE.writeNbt(this.translation.f_82480_).ifPresent(tag -> translation.m_128365_("y", tag));
        Adapters.DOUBLE.writeNbt(this.translation.f_82481_).ifPresent(tag -> translation.m_128365_("z", tag));
        nbt.m_128365_("translation", (Tag)translation);
        CompoundTag rotation = new CompoundTag();
        Adapters.DOUBLE.writeNbt(this.rotation.f_82479_).ifPresent(tag -> rotation.m_128365_("pitch", tag));
        Adapters.DOUBLE.writeNbt(this.rotation.f_82480_).ifPresent(tag -> rotation.m_128365_("yaw", tag));
        Adapters.DOUBLE.writeNbt(this.rotation.f_82481_).ifPresent(tag -> rotation.m_128365_("roll", tag));
        nbt.m_128365_("rotation", (Tag)rotation);
        CompoundTag scale = new CompoundTag();
        Adapters.DOUBLE.writeNbt(this.scale.f_82479_).ifPresent(tag -> scale.m_128365_("x", tag));
        Adapters.DOUBLE.writeNbt(this.scale.f_82480_).ifPresent(tag -> scale.m_128365_("y", tag));
        Adapters.DOUBLE.writeNbt(this.scale.f_82481_).ifPresent(tag -> scale.m_128365_("z", tag));
        nbt.m_128365_("scale", (Tag)scale);
        ListTag elements = new ListTag();
        for (HologramElement child : this.children) {
            ADAPTER.writeNbt(child).ifPresent(arg_0 -> elements.add(arg_0));
        }
        nbt.m_128365_("children", (Tag)elements);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.setTranslation(new Vec3(Adapters.DOUBLE.readNbt(nbt.m_128469_("translation").m_128423_("x")).orElse(0.0).doubleValue(), Adapters.DOUBLE.readNbt(nbt.m_128469_("translation").m_128423_("y")).orElse(0.0).doubleValue(), Adapters.DOUBLE.readNbt(nbt.m_128469_("translation").m_128423_("z")).orElse(0.0).doubleValue()));
        this.setEulerRotation(new Vec3(Adapters.DOUBLE.readNbt(nbt.m_128469_("rotation").m_128423_("pitch")).orElse(0.0).doubleValue(), Adapters.DOUBLE.readNbt(nbt.m_128469_("rotation").m_128423_("yaw")).orElse(0.0).doubleValue(), Adapters.DOUBLE.readNbt(nbt.m_128469_("rotation").m_128423_("roll")).orElse(0.0).doubleValue()));
        this.setScale(new Vec3(Adapters.DOUBLE.readNbt(nbt.m_128469_("scale").m_128423_("x")).orElse(1.0).doubleValue(), Adapters.DOUBLE.readNbt(nbt.m_128469_("scale").m_128423_("y")).orElse(1.0).doubleValue(), Adapters.DOUBLE.readNbt(nbt.m_128469_("scale").m_128423_("z")).orElse(1.0).doubleValue()));
        this.children = new ArrayList<HologramElement>();
        for (Tag tag : nbt.m_128437_("children", 10)) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag child = (CompoundTag)tag;
            ADAPTER.readNbt((Tag)child).ifPresent(this.children::add);
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<HologramElement> {
        public Adapter() {
            super("type", true);
            this.register("root", RootHologramElement.class, RootHologramElement::new);
            this.register("model", ModelHologramElement.class, ModelHologramElement::new);
            this.register("text", TextHologramElement.class, TextHologramElement::new);
            this.register("item", ItemHologramElement.class, ItemHologramElement::new);
        }
    }
}

