/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.hologram;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.entity.hologram.HologramElement;
import iskallia.vault.core.data.adapter.Adapters;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemHologramElement
extends HologramElement {
    private ItemStack stack;
    private boolean xCentered;
    private boolean yCentered;

    public ItemHologramElement() {
    }

    public ItemHologramElement(ItemStack stack, boolean xCentered, boolean yCentered) {
        this.stack = stack;
        this.xCentered = xCentered;
        this.yCentered = yCentered;
    }

    @Override
    protected void renderInternal(PoseStack matrices, MultiBufferSource bufferSource, float partialTick, int light, int overlay) {
        super.renderInternal(matrices, bufferSource, partialTick, light, overlay);
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        matrices.m_85836_();
        matrices.m_85845_(this.getQuaternionRotation(new Vec3(0.0, 0.0, 180.0)));
        renderer.m_174269_(this.stack, ItemTransforms.TransformType.FIXED, light, OverlayTexture.f_118083_, matrices, bufferSource, light);
        matrices.m_85849_();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.ITEM_STACK.writeNbt(this.stack).ifPresent(tag -> nbt.m_128365_("stack", tag));
            Adapters.BOOLEAN.writeNbt(this.xCentered).ifPresent(tag -> nbt.m_128365_("x_centered", tag));
            Adapters.BOOLEAN.writeNbt(this.yCentered).ifPresent(tag -> nbt.m_128365_("y_centered", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.stack = Adapters.ITEM_STACK.readNbt(nbt.m_128423_("stack")).orElse(ItemStack.f_41583_);
        this.xCentered = Adapters.BOOLEAN.readNbt(nbt.m_128423_("x_centered")).orElse(false);
        this.yCentered = Adapters.BOOLEAN.readNbt(nbt.m_128423_("y_centered")).orElse(false);
    }
}

