/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.hologram;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.hologram.HologramElement;
import iskallia.vault.block.entity.hologram.model.MeshPart;
import iskallia.vault.core.data.adapter.Adapters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModelHologramElement
extends HologramElement {
    private ResourceLocation textureId;
    private int textureWidth;
    private int textureHeight;
    private int color;
    private List<MeshPart> mesh;
    @OnlyIn(value=Dist.CLIENT)
    private DelegatedModel cache;

    public ModelHologramElement() {
    }

    public ModelHologramElement(ResourceLocation textureId, int textureWidth, int textureHeight, int color, MeshPart ... mesh) {
        this.textureId = textureId;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.color = color;
        this.mesh = new ArrayList<MeshPart>(Arrays.asList(mesh));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderInternal(PoseStack matrices, MultiBufferSource bufferSource, float partialTick, int light, int overlay) {
        if (this.cache == null) {
            MeshDefinition data = new MeshDefinition();
            PartDefinition root = data.m_171576_();
            for (MeshPart part : this.mesh) {
                part.attach(root);
            }
            this.cache = new DelegatedModel(LayerDefinition.m_171565_((MeshDefinition)data, (int)this.textureWidth, (int)this.textureHeight).m_171564_());
        }
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.textureId));
        this.cache.m_7695_(matrices, buffer, light, overlay, (float)(this.color >> 16 & 0xFF) / 255.0f, (float)(this.color >>> 8 & 0xFF) / 255.0f, (float)(this.color & 0xFF) / 255.0f, (float)(this.color >>> 24) / 255.0f);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag texture = new CompoundTag();
        Adapters.IDENTIFIER.writeNbt(this.textureId).ifPresent(tag -> texture.m_128365_("id", tag));
        Adapters.INT.writeNbt(this.textureWidth).ifPresent(tag -> texture.m_128365_("width", tag));
        Adapters.INT.writeNbt(this.textureHeight).ifPresent(tag -> texture.m_128365_("height", tag));
        Adapters.INT.writeNbt(this.color).ifPresent(tag -> texture.m_128365_("color", tag));
        nbt.m_128365_("texture", (Tag)texture);
        ListTag mesh = new ListTag();
        for (MeshPart part : this.mesh) {
            part.writeNbt().ifPresent(arg_0 -> mesh.add(arg_0));
        }
        nbt.m_128365_("mesh", (Tag)mesh);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.textureId = Adapters.IDENTIFIER.readNbt(nbt.m_128469_("texture").m_128423_("id")).orElseGet(() -> VaultMod.id("textures/block/error_texture"));
        this.textureWidth = Adapters.INT.readNbt(nbt.m_128469_("texture").m_128423_("width")).orElse(2);
        this.textureHeight = Adapters.INT.readNbt(nbt.m_128469_("texture").m_128423_("height")).orElse(2);
        this.color = Adapters.INT.readNbt(nbt.m_128469_("texture").m_128423_("color")).orElse(-1);
        this.mesh = new ArrayList<MeshPart>();
        for (Tag tag : nbt.m_128437_("mesh", 10)) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compound = (CompoundTag)tag;
            MeshPart part = new MeshPart();
            part.readNbt(compound);
            this.mesh.add(part);
        }
    }

    public static class DelegatedModel
    extends Model {
        private final ModelPart root;

        public DelegatedModel(ModelPart root) {
            super(RenderType::m_110473_);
            this.root = root;
        }

        public void m_7695_(PoseStack matrices, VertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha) {
            this.root.m_104306_(matrices, buffer, light, overlay, red, green, blue, alpha);
        }
    }
}

