/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.hologram;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.entity.hologram.HologramElement;
import iskallia.vault.core.data.adapter.Adapters;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TextHologramElement
extends HologramElement {
    private Component text;
    private boolean xCentered;
    private boolean yCentered;
    private int color;

    public TextHologramElement() {
    }

    public TextHologramElement(Component text, boolean xCentered, boolean yCentered, int color) {
        this.text = text;
        this.xCentered = xCentered;
        this.yCentered = yCentered;
        this.color = color;
    }

    @Override
    protected void renderInternal(PoseStack matrices, MultiBufferSource bufferSource, float partialTick, int light, int overlay) {
        float f;
        float x;
        super.renderInternal(matrices, bufferSource, partialTick, light, overlay);
        Font font = Minecraft.m_91087_().f_91062_;
        float f2 = x = this.xCentered ? (float)(-font.m_92852_((FormattedText)this.text)) / 2.0f : 0.0f;
        if (this.yCentered) {
            Objects.requireNonNull(font);
            f = (float)(-9) / 2.0f;
        } else {
            f = 0.0f;
        }
        float y = f;
        font.m_92889_(matrices, this.text, x, y, this.color);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            nbt.m_128359_("text", Component.Serializer.m_130703_((Component)this.text));
            Adapters.BOOLEAN.writeNbt(this.xCentered).ifPresent(tag -> nbt.m_128365_("x_centered", tag));
            Adapters.BOOLEAN.writeNbt(this.yCentered).ifPresent(tag -> nbt.m_128365_("y_centered", tag));
            Adapters.INT.writeNbt(this.color).ifPresent(tag -> nbt.m_128365_("color", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.text = Component.Serializer.m_130701_((String)nbt.m_128461_("text"));
        this.xCentered = Adapters.BOOLEAN.readNbt(nbt.m_128423_("x_centered")).orElse(false);
        this.yCentered = Adapters.BOOLEAN.readNbt(nbt.m_128423_("y_centered")).orElse(false);
        this.color = Adapters.INT.readNbt(nbt.m_128423_("color")).orElse(0xFFFFFF);
    }
}

