/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.hologram.model;

import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.hologram.model.MeshBuilder;
import iskallia.vault.block.entity.hologram.model.MeshBuilderAction;
import iskallia.vault.core.data.adapter.Adapters;
import java.util.Optional;
import net.minecraft.client.model.geom.builders.CubeDefinition;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CuboidMeshBuilderAction
extends MeshBuilderAction {
    private String name;
    private Boolean mirrored;
    private Vec2 texture;
    private Vec2 scale;
    private Vector3f position;
    private Vector3f size;
    private Vector3f dilation;

    public CuboidMeshBuilderAction() {
    }

    public CuboidMeshBuilderAction(String name, Boolean mirrored, Vec2 texture, Vec2 scale, Vector3f position, Vector3f size, Vector3f dilation) {
        this.name = name;
        this.mirrored = mirrored;
        this.texture = texture;
        this.scale = scale;
        this.position = position;
        this.size = size;
        this.dilation = dilation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void apply(MeshBuilder builder) {
        builder.getCuboids().add(new CubeDefinition(this.name, this.texture != null ? this.texture.f_82470_ : builder.getTexture().f_82470_, this.texture != null ? this.texture.f_82471_ : builder.getTexture().f_82471_, this.position.m_122239_(), this.position.m_122260_(), this.position.m_122269_(), this.size.m_122239_(), this.size.m_122260_(), this.size.m_122269_(), new CubeDeformation(this.dilation.m_122239_(), this.dilation.m_122260_(), this.dilation.m_122269_()), this.mirrored != null ? this.mirrored.booleanValue() : builder.isMirrored(), this.scale.f_82470_, this.scale.f_82471_));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UTF_8.writeNbt(this.name).ifPresent(tag -> nbt.m_128365_("name", tag));
        Adapters.BOOLEAN.writeNbt(this.mirrored).ifPresent(tag -> nbt.m_128365_("mirrored", tag));
        if (this.texture != null) {
            CompoundTag texture = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.texture.f_82470_)).ifPresent(tag -> texture.m_128365_("u", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.texture.f_82471_)).ifPresent(tag -> texture.m_128365_("v", tag));
            nbt.m_128365_("texture", (Tag)texture);
        }
        if (!this.scale.m_82476_(Vec2.f_82463_)) {
            CompoundTag scale = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.scale.f_82470_)).ifPresent(tag -> scale.m_128365_("u", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.scale.f_82471_)).ifPresent(tag -> scale.m_128365_("v", tag));
            nbt.m_128365_("scale", (Tag)scale);
        }
        if (!this.position.equals((Object)Vector3f.f_176763_)) {
            CompoundTag position = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.position.m_122239_())).ifPresent(tag -> position.m_128365_("x", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.position.m_122260_())).ifPresent(tag -> position.m_128365_("y", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.position.m_122269_())).ifPresent(tag -> position.m_128365_("z", tag));
            nbt.m_128365_("position", (Tag)position);
        }
        if (!this.position.equals((Object)new Vector3f(1.0f, 1.0f, 1.0f))) {
            CompoundTag size = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.size.m_122239_())).ifPresent(tag -> size.m_128365_("x", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.size.m_122260_())).ifPresent(tag -> size.m_128365_("y", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.size.m_122269_())).ifPresent(tag -> size.m_128365_("z", tag));
            nbt.m_128365_("size", (Tag)size);
        }
        if (!this.position.equals((Object)Vector3f.f_176763_)) {
            CompoundTag dilation = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.dilation.m_122239_())).ifPresent(tag -> dilation.m_128365_("x", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.dilation.m_122260_())).ifPresent(tag -> dilation.m_128365_("y", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.dilation.m_122269_())).ifPresent(tag -> dilation.m_128365_("z", tag));
            nbt.m_128365_("dilation", (Tag)dilation);
        }
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        Vec2 vec2;
        this.name = Adapters.UTF_8.readNbt(nbt.m_128423_("name")).orElse(null);
        this.mirrored = Adapters.BOOLEAN.readNbt(nbt.m_128423_("mirrored")).orElse(null);
        Tag tag = nbt.m_128423_("texture");
        if (tag instanceof CompoundTag) {
            CompoundTag texture = (CompoundTag)tag;
            vec2 = new Vec2(Adapters.FLOAT.readNbt(texture.m_128423_("u")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(texture.m_128423_("v")).orElse(Float.valueOf(0.0f)).floatValue());
        } else {
            vec2 = null;
        }
        this.texture = vec2;
        this.scale = new Vec2(Adapters.FLOAT.readNbt(nbt.m_128469_("scale").m_128423_("u")).orElse(Float.valueOf(1.0f)).floatValue(), Adapters.FLOAT.readNbt(nbt.m_128469_("scale").m_128423_("v")).orElse(Float.valueOf(1.0f)).floatValue());
        this.position = new Vector3f(Adapters.FLOAT.readNbt(nbt.m_128469_("position").m_128423_("x")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(nbt.m_128469_("position").m_128423_("y")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(nbt.m_128469_("position").m_128423_("z")).orElse(Float.valueOf(0.0f)).floatValue());
        this.size = new Vector3f(Adapters.FLOAT.readNbt(nbt.m_128469_("size").m_128423_("x")).orElse(Float.valueOf(1.0f)).floatValue(), Adapters.FLOAT.readNbt(nbt.m_128469_("size").m_128423_("y")).orElse(Float.valueOf(1.0f)).floatValue(), Adapters.FLOAT.readNbt(nbt.m_128469_("size").m_128423_("z")).orElse(Float.valueOf(1.0f)).floatValue());
        this.dilation = new Vector3f(Adapters.FLOAT.readNbt(nbt.m_128469_("dilation").m_128423_("x")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(nbt.m_128469_("dilation").m_128423_("y")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(nbt.m_128469_("dilation").m_128423_("z")).orElse(Float.valueOf(0.0f)).floatValue());
    }
}

