/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.hologram.model;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.hologram.model.CuboidMeshBuilderAction;
import iskallia.vault.block.entity.hologram.model.MeshBuilder;
import iskallia.vault.block.entity.hologram.model.MeshBuilderAction;
import iskallia.vault.block.entity.hologram.model.MirrorMeshBuilderAction;
import iskallia.vault.block.entity.hologram.model.TextureMeshBuilderAction;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MeshPart
implements ISerializable<CompoundTag, JsonObject> {
    private String name;
    private Vector3f pivot;
    private Vector3f rotation;
    private List<MeshBuilderAction> builder;
    private List<MeshPart> children;

    public MeshPart() {
    }

    public MeshPart(String name) {
        this.name = name;
        this.pivot = Vector3f.f_176763_;
        this.rotation = Vector3f.f_176763_;
        this.builder = new ArrayList<MeshBuilderAction>();
        this.children = new ArrayList<MeshPart>();
    }

    public MeshPart uv(float u, float v) {
        this.builder.add(new TextureMeshBuilderAction(u, v));
        return this;
    }

    public MeshPart mirror(boolean mirrored) {
        this.builder.add(new MirrorMeshBuilderAction(mirrored));
        return this;
    }

    public MeshPart cuboid(String name, Vector3f position, Vector3f size, Vector3f dilation, Vec2 texture) {
        this.builder.add(new CuboidMeshBuilderAction(name, null, texture, Vec2.f_82463_, position, size, dilation));
        return this;
    }

    public MeshPart cuboid(String name, Vector3f position, Vector3f size, Vec2 texture) {
        this.builder.add(new CuboidMeshBuilderAction(name, null, texture, Vec2.f_82463_, position, size, Vector3f.f_176763_));
        return this;
    }

    public MeshPart cuboid(Vector3f position, Vector3f size) {
        this.builder.add(new CuboidMeshBuilderAction(null, null, null, Vec2.f_82463_, position, size, Vector3f.f_176763_));
        return this;
    }

    public MeshPart cuboid(String name, Vector3f position, Vector3f size) {
        this.builder.add(new CuboidMeshBuilderAction(name, null, null, Vec2.f_82463_, position, size, Vector3f.f_176763_));
        return this;
    }

    public MeshPart cuboid(String name, Vector3f position, Vector3f size, Vector3f dilation) {
        this.builder.add(new CuboidMeshBuilderAction(name, null, null, Vec2.f_82463_, position, size, dilation));
        return this;
    }

    public MeshPart cuboid(Vector3f position, Vector3f size, boolean mirrored) {
        this.builder.add(new CuboidMeshBuilderAction(null, mirrored, null, Vec2.f_82463_, position, size, Vector3f.f_176763_));
        return this;
    }

    public MeshPart cuboid(Vector3f position, Vector3f size, Vector3f dilation, Vec2 scale) {
        this.builder.add(new CuboidMeshBuilderAction(null, null, null, scale, position, size, dilation));
        return this;
    }

    public MeshPart cuboid(Vector3f position, Vector3f size, Vector3f dilation) {
        this.builder.add(new CuboidMeshBuilderAction(null, null, null, Vec2.f_82463_, position, size, dilation));
        return this;
    }

    public MeshPart setPivot(Vector3f pivot) {
        this.pivot = pivot;
        return this;
    }

    public MeshPart setRotation(Vector3f rotation) {
        this.rotation = rotation;
        return this;
    }

    public MeshPart add(MeshPart child) {
        this.children.add(child);
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void attach(PartDefinition root) {
        MeshBuilder builder = new MeshBuilder().build(this.builder);
        PartDefinition self = new PartDefinition(builder.getCuboids(), PartPose.m_171423_((float)this.pivot.m_122239_(), (float)this.pivot.m_122260_(), (float)this.pivot.m_122269_(), (float)this.rotation.m_122239_(), (float)this.rotation.m_122260_(), (float)this.rotation.m_122269_()));
        PartDefinition oldSelf = root.f_171579_.put(this.name, self);
        if (oldSelf != null) {
            self.f_171579_.putAll(oldSelf.f_171579_);
        }
        for (MeshPart child : this.children) {
            child.attach(self);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UTF_8.writeNbt(this.name).ifPresent(tag -> nbt.m_128365_("name", tag));
        CompoundTag pivot = new CompoundTag();
        Adapters.FLOAT.writeNbt(Float.valueOf(this.pivot.m_122239_())).ifPresent(tag -> pivot.m_128365_("x", tag));
        Adapters.FLOAT.writeNbt(Float.valueOf(this.pivot.m_122260_())).ifPresent(tag -> pivot.m_128365_("y", tag));
        Adapters.FLOAT.writeNbt(Float.valueOf(this.pivot.m_122269_())).ifPresent(tag -> pivot.m_128365_("z", tag));
        nbt.m_128365_("pivot", (Tag)pivot);
        CompoundTag rotation = new CompoundTag();
        Adapters.FLOAT.writeNbt(Float.valueOf(this.rotation.m_122239_())).ifPresent(tag -> rotation.m_128365_("pitch", tag));
        Adapters.FLOAT.writeNbt(Float.valueOf(this.rotation.m_122260_())).ifPresent(tag -> rotation.m_128365_("yaw", tag));
        Adapters.FLOAT.writeNbt(Float.valueOf(this.rotation.m_122269_())).ifPresent(tag -> rotation.m_128365_("roll", tag));
        nbt.m_128365_("rotation", (Tag)rotation);
        ListTag builder = new ListTag();
        for (MeshBuilderAction action : this.builder) {
            MeshBuilderAction.ADAPTER.writeNbt(action).ifPresent(arg_0 -> builder.add(arg_0));
        }
        nbt.m_128365_("builder", (Tag)builder);
        ListTag children = new ListTag();
        for (MeshPart child : this.children) {
            child.writeNbt().ifPresent(arg_0 -> children.add(arg_0));
        }
        nbt.m_128365_("children", (Tag)children);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        Vector3f vector3f;
        Vector3f vector3f2;
        this.name = Adapters.UTF_8.readNbt(nbt.m_128423_("name")).orElse(null);
        Tag tag = nbt.m_128423_("pivot");
        if (tag instanceof CompoundTag) {
            CompoundTag pivot = (CompoundTag)tag;
            vector3f2 = new Vector3f(Adapters.FLOAT.readNbt(pivot.m_128423_("x")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(pivot.m_128423_("y")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(pivot.m_128423_("z")).orElse(Float.valueOf(0.0f)).floatValue());
        } else {
            vector3f2 = Vector3f.f_176763_;
        }
        this.pivot = vector3f2;
        tag = nbt.m_128423_("rotation");
        if (tag instanceof CompoundTag) {
            CompoundTag rotation = (CompoundTag)tag;
            vector3f = new Vector3f(Adapters.FLOAT.readNbt(rotation.m_128423_("x")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(rotation.m_128423_("y")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(rotation.m_128423_("z")).orElse(Float.valueOf(0.0f)).floatValue());
        } else {
            vector3f = Vector3f.f_176763_;
        }
        this.rotation = vector3f;
        this.builder = new ArrayList<MeshBuilderAction>();
        for (Tag tag2 : nbt.m_128437_("builder", 10)) {
            if (!(tag2 instanceof CompoundTag)) continue;
            CompoundTag action = (CompoundTag)tag2;
            MeshBuilderAction.ADAPTER.readNbt((Tag)action).ifPresent(this.builder::add);
        }
        this.children = new ArrayList<MeshPart>();
        for (Tag tag2 : nbt.m_128437_("children", 10)) {
            if (!(tag2 instanceof CompoundTag)) continue;
            CompoundTag compound = (CompoundTag)tag2;
            MeshPart child = new MeshPart();
            child.readNbt(compound);
            this.children.add(child);
        }
    }
}

