/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.hologram.model;

import iskallia.vault.block.entity.hologram.model.MeshBuilder;
import iskallia.vault.block.entity.hologram.model.MeshBuilderAction;
import iskallia.vault.core.data.adapter.Adapters;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextureMeshBuilderAction
extends MeshBuilderAction {
    private Vec2 texture;

    public TextureMeshBuilderAction() {
    }

    public TextureMeshBuilderAction(float textureX, float textureY) {
        this.texture = new Vec2(textureX, textureY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void apply(MeshBuilder builder) {
        if (this.texture != null) {
            builder.setTexture(this.texture);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag texture = new CompoundTag();
        Adapters.FLOAT.writeNbt(Float.valueOf(this.texture.f_82470_)).ifPresent(tag -> texture.m_128365_("u", tag));
        Adapters.FLOAT.writeNbt(Float.valueOf(this.texture.f_82471_)).ifPresent(tag -> texture.m_128365_("v", tag));
        nbt.m_128365_("texture", (Tag)texture);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        Vec2 vec2;
        Tag tag = nbt.m_128423_("texture");
        if (tag instanceof CompoundTag) {
            CompoundTag texture = (CompoundTag)tag;
            vec2 = new Vec2(Adapters.FLOAT.readNbt(texture.m_128423_("u")).orElse(Float.valueOf(0.0f)).floatValue(), Adapters.FLOAT.readNbt(texture.m_128423_("v")).orElse(Float.valueOf(0.0f)).floatValue());
        } else {
            vec2 = Vec2.f_82462_;
        }
        this.texture = vec2;
    }
}

