/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.item;

import com.mojang.authlib.GameProfile;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.McClientHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FinalVaultFrameBlockItem
extends BlockItem {
    public FinalVaultFrameBlockItem(Block blockIn) {
        super(blockIn, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        return Rarity.EPIC;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
        String stringUUID = blockEntityTag.m_128461_("OwnerUUID");
        UUID ownerUUID = stringUUID.isEmpty() ? new UUID(0L, 0L) : UUID.fromString(stringUUID);
        String ownerNickname = blockEntityTag.m_128461_("OwnerNickname");
        String displayNickname = McClientHelper.getOnlineProfile(ownerUUID).map(GameProfile::getName).orElse(ownerNickname);
        MutableComponent ownerText = new TextComponent("Owner:").m_130940_(ChatFormatting.GOLD);
        MutableComponent displayText = new TextComponent(displayNickname).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
        tooltip.add((Component)ownerText.m_7220_((Component)displayText));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public void m_6883_(@Nonnull ItemStack itemStack, Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        CompoundTag blockEntityTag = itemStack.m_41698_("BlockEntityTag");
        if (blockEntityTag.m_128441_("OwnerUUID")) {
            return;
        }
        FinalVaultFrameBlockItem.writeToItemStack(itemStack, player);
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    public static void writeToItemStack(ItemStack itemStack, ServerPlayer owner) {
        FinalVaultFrameBlockItem.writeToItemStack(itemStack, owner.m_142081_(), owner.m_7755_().getString());
    }

    public static void writeToItemStack(ItemStack itemStack, UUID ownerUUID, String ownerNickname) {
        CompoundTag blockEntityTag = itemStack.m_41698_("BlockEntityTag");
        blockEntityTag.m_128359_("OwnerUUID", ownerUUID.toString());
        blockEntityTag.m_128359_("OwnerNickname", ownerNickname);
    }
}

