/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.item;

import com.mojang.authlib.GameProfile;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.McClientHelper;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulPlaqueBlockItem
extends BlockItem {
    public SoulPlaqueBlockItem(Block block) {
        super(block, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    public void m_6883_(@Nonnull ItemStack itemStack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (SoulPlaqueBlockItem.getOwnerUUID(itemStack).isEmpty()) {
            SoulPlaqueBlockItem.setOwnerUUID(itemStack, player.m_142081_());
            SoulPlaqueBlockItem.setOwnerName(itemStack, player.m_7755_().getString());
        }
        int tier = ModConfigs.ASCENSION.getTier(SoulPlaqueBlockItem.getScore(itemStack));
        if (SoulPlaqueBlockItem.getTier(itemStack).orElse(0) != tier) {
            SoulPlaqueBlockItem.setTier(itemStack, tier);
        }
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    public static Optional<UUID> getOwnerUUID(ItemStack stack) {
        CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
        String uuidString = blockEntityTag.m_128461_("OwnerUuid");
        return uuidString.isEmpty() ? Optional.empty() : Optional.of(UUID.fromString(uuidString));
    }

    public static Optional<String> getOwnerName(ItemStack stack) {
        CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
        String name = blockEntityTag.m_128461_("OwnerName");
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }

    public static OptionalInt getTier(ItemStack stack) {
        int tier = stack.m_41784_().m_128451_("CustomModelData");
        if (tier < 1 || tier > 8) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(tier);
    }

    public static int getScore(ItemStack stack) {
        return stack.m_41698_("BlockEntityTag").m_128451_("Score");
    }

    public static void setOwnerUUID(ItemStack stack, UUID uuid) {
        stack.m_41698_("BlockEntityTag").m_128359_("OwnerUuid", uuid.toString());
    }

    public static void setOwnerName(ItemStack stack, String name) {
        stack.m_41698_("BlockEntityTag").m_128359_("OwnerName", name);
    }

    public static void setTier(ItemStack stack, int tier) {
        stack.m_41784_().m_128405_("CustomModelData", tier);
    }

    public static void setScore(ItemStack stack, int score) {
        stack.m_41698_("BlockEntityTag").m_128405_("Score", score);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        String ownerNickname = McClientHelper.getOnlineProfile(SoulPlaqueBlockItem.getOwnerUUID(stack).orElse(null)).map(GameProfile::getName).orElseGet(() -> SoulPlaqueBlockItem.getOwnerName(stack).orElse(""));
        int score = SoulPlaqueBlockItem.getScore(stack);
        if (!ownerNickname.isEmpty()) {
            tooltip.add((Component)new TextComponent("Awarded to: ").m_7220_((Component)new TextComponent(ownerNickname).m_130940_(ChatFormatting.YELLOW)));
        } else {
            tooltip.add((Component)new TextComponent("Awarded to: ").m_7220_((Component)new TextComponent("???").m_130940_(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)new TextComponent("Score: ").m_7220_((Component)new TextComponent("" + score).m_130940_(ChatFormatting.GRAY)));
    }

    public static ItemStack create(ServerPlayer owner, int score) {
        return SoulPlaqueBlockItem.create(owner == null ? null : owner.m_142081_(), owner == null ? null : owner.m_7755_().getString(), score);
    }

    public static ItemStack create(UUID ownerUUID, String ownerNickname, int score) {
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.SOUL_PLAQUE);
        if (ownerUUID != null) {
            SoulPlaqueBlockItem.setOwnerUUID(itemStack, ownerUUID);
        }
        if (ownerNickname != null) {
            SoulPlaqueBlockItem.setOwnerName(itemStack, ownerNickname);
        }
        SoulPlaqueBlockItem.setTier(itemStack, ModConfigs.ASCENSION.getTier(score));
        SoulPlaqueBlockItem.setScore(itemStack, score);
        return itemStack;
    }
}

