/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultArtifactBlock;
import iskallia.vault.block.entity.ArtifactProjectorTileEntity;
import iskallia.vault.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;

public class ArtifactProjectorRenderer
implements BlockEntityRenderer<ArtifactProjectorTileEntity> {
    public static final ResourceLocation BOOK_TEXTURE = VaultMod.id("entity/vault_projector_book");
    public static final Material BOOK_MATERIAL = new Material(TextureAtlas.f_118259_, BOOK_TEXTURE);
    private final BookModel bookModel;

    public ArtifactProjectorRenderer(BlockEntityRendererProvider.Context context) {
        this.bookModel = new BookModel(context.m_173582_(ModelLayers.f_171271_));
    }

    public void render(ArtifactProjectorTileEntity tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = tile.m_58904_();
        if (world == null) {
            return;
        }
        Direction dir = (Direction)tile.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Direction usedDir = switch (dir) {
            default -> Direction.EAST;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.EAST -> Direction.NORTH;
            case Direction.WEST -> Direction.SOUTH;
        };
        int rot = 90;
        if (dir == Direction.WEST) {
            rot = 0;
        }
        if (dir == Direction.SOUTH) {
            rot = 270;
        }
        if (dir == Direction.EAST) {
            rot = 180;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.05, 0.5);
        float f = (float)tile.time + partialTicks;
        matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(-((float)Math.toRadians(rot))));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(66.0f));
        float f3 = Mth.m_14179_((float)partialTicks, (float)tile.oFlip, (float)tile.flip);
        float f4 = Mth.m_14187_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.m_14187_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14179_((float)partialTicks, (float)tile.oOpen, (float)tile.open);
        this.bookModel.m_102292_(f, Mth.m_14036_((float)f4, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer vertexconsumer = BOOK_MATERIAL.m_119194_(buffer, RenderType::m_110446_);
        this.bookModel.m_102316_(matrixStack, vertexconsumer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        if (tile.completed) {
            for (int y = 1; y < 6; ++y) {
                for (int x = 1; x < 6; ++x) {
                    TransparentRenderType newBuffer = new TransparentRenderType((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 1.0f, null);
                    int value = x + (y - 1) * 5;
                    int order = (25 - value + 24) % 25;
                    BlockPos pos = tile.m_58899_().m_6630_(6 - y).m_5484_(usedDir, 3 - x);
                    if (dir == Direction.NORTH || dir == Direction.SOUTH) {
                        pos = tile.m_58899_().m_6630_(6 - y).m_5484_(usedDir, -3 + x);
                    }
                    BlockState artifact = (BlockState)((BlockState)((BlockState)ModBlocks.VAULT_ARTIFACT.m_49966_().m_61124_((Property)VaultArtifactBlock.ORDER_PROPERTY, (Comparable)Integer.valueOf(order + 1))).m_61124_((Property)VaultArtifactBlock.GRAYSCALE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir);
                    matrixStack.m_85836_();
                    if (dir == Direction.EAST) {
                        matrixStack.m_85837_(-0.015625, (double)(6 - y), (double)(-3 + x));
                    }
                    if (dir == Direction.NORTH) {
                        matrixStack.m_85837_((double)(-3 + x), (double)(6 - y), 0.015625);
                    }
                    if (dir == Direction.WEST) {
                        matrixStack.m_85837_(0.015625, (double)(6 - y), (double)(3 - x));
                    }
                    if (dir == Direction.SOUTH) {
                        matrixStack.m_85837_((double)(3 - x), (double)(6 - y), -0.015625);
                    }
                    ArtifactProjectorRenderer.renderBlockState(artifact, matrixStack, newBuffer, Minecraft.m_91087_().m_91289_(), tile.m_58904_(), pos);
                    matrixStack.m_85849_();
                }
            }
        } else {
            for (int y = 1; y < 6; ++y) {
                for (int x = 1; x < 6; ++x) {
                    TransparentRenderType newBuffer = new TransparentRenderType((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0.5f, null);
                    int value = x + (y - 1) * 5;
                    int order = (25 - value + 24) % 25;
                    BlockPos pos = tile.m_58899_().m_6630_(6 - y).m_5484_(usedDir, 3 - x);
                    if (dir == Direction.NORTH || dir == Direction.SOUTH) {
                        pos = tile.m_58899_().m_6630_(6 - y).m_5484_(usedDir, -3 + x);
                    }
                    BlockState blockState = tile.m_58904_().m_8055_(pos);
                    BlockState artifact = (BlockState)((BlockState)((BlockState)ModBlocks.VAULT_ARTIFACT.m_49966_().m_61124_((Property)VaultArtifactBlock.ORDER_PROPERTY, (Comparable)Integer.valueOf(order + 1))).m_61124_((Property)VaultArtifactBlock.GRAYSCALE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir);
                    if (blockState.m_61138_((Property)VaultArtifactBlock.ORDER_PROPERTY)) {
                        if ((Integer)blockState.m_61143_((Property)VaultArtifactBlock.ORDER_PROPERTY) == order + 1 && blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == dir) continue;
                        newBuffer = new TransparentRenderType((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0.5f, new Vec3((double)0.8f, 0.0, 0.0));
                    }
                    matrixStack.m_85836_();
                    if (dir == Direction.EAST) {
                        matrixStack.m_85837_(-0.015625, (double)(6 - y), (double)(-3 + x));
                    }
                    if (dir == Direction.NORTH) {
                        matrixStack.m_85837_((double)(-3 + x), (double)(6 - y), 0.015625);
                    }
                    if (dir == Direction.WEST) {
                        matrixStack.m_85837_(0.015625, (double)(6 - y), (double)(3 - x));
                    }
                    if (dir == Direction.SOUTH) {
                        matrixStack.m_85837_((double)(3 - x), (double)(6 - y), -0.015625);
                    }
                    ArtifactProjectorRenderer.renderBlockState(artifact, matrixStack, newBuffer, Minecraft.m_91087_().m_91289_(), tile.m_58904_(), pos);
                    matrixStack.m_85849_();
                }
            }
        }
    }

    private static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                ArtifactProjectorRenderer.renderBlockState(state, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderType((RenderType)type);
        blockRenderer.m_110937_().m_111047_((BlockAndTintGetter)world, blockRenderer.m_110910_(state), state, pos, matrixStack, buffer.m_6299_(type), false, world.f_46441_, 0L, OverlayTexture.f_118083_);
        ForgeHooksClient.setRenderType(null);
    }

    public static class TransparentRenderType
    implements MultiBufferSource {
        private final float alpha;
        private final Vec3 color;
        private final MultiBufferSource source;

        public TransparentRenderType(MultiBufferSource source, float alpha, Vec3 color) {
            this.source = source;
            this.alpha = alpha;
            this.color = color;
        }

        public VertexConsumer m_6299_(RenderType type) {
            RenderType renderType = type;
            if (renderType instanceof RenderType.CompositeRenderType) {
                RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)compositeRenderType.f_110511_.f_110576_).f_110328_.orElse(InventoryMenu.f_39692_);
                renderType = RenderType.m_110470_((ResourceLocation)texture);
            } else if (renderType.toString().equals(Sheets.m_110792_().toString())) {
                renderType = Sheets.m_110792_();
            }
            return new TransparentRenderVertex(this.source.m_6299_(renderType), this.alpha, this.color);
        }
    }

    public static class TransparentRenderVertex
    implements VertexConsumer {
        private final VertexConsumer source;
        private final float alpha;
        private final Vec3 color;

        public TransparentRenderVertex(VertexConsumer source, float alpha, Vec3 color) {
            this.source = source;
            this.alpha = alpha;
            this.color = color;
        }

        public VertexConsumer m_5483_(double x, double y, double z) {
            return this.source.m_5483_(x, y, z);
        }

        public VertexConsumer m_85982_(Matrix4f matrixIn, float x, float y, float z) {
            return this.source.m_85982_(matrixIn, x, y, z);
        }

        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            if (this.color != null) {
                return this.source.m_6122_((int)(this.color.f_82479_ * 256.0), (int)(this.color.f_82480_ * 256.0), (int)(this.color.f_82481_ * 256.0), (int)((float)alpha * this.alpha));
            }
            return this.source.m_6122_(red, green, blue, (int)((float)alpha * this.alpha));
        }

        public VertexConsumer m_7421_(float u, float v) {
            return this.source.m_7421_(u, v);
        }

        public VertexConsumer m_7122_(int u, int v) {
            return this.source.m_7122_(u, v);
        }

        public VertexConsumer m_7120_(int u, int v) {
            return this.source.m_7120_(u, v);
        }

        public VertexConsumer m_5601_(float x, float y, float z) {
            return this.source.m_5601_(x, y, z);
        }

        public VertexConsumer m_85977_(Matrix3f matrixIn, float x, float y, float z) {
            return this.source.m_85977_(matrixIn, x, y, z);
        }

        public void m_5752_() {
            this.source.m_5752_();
        }

        public void m_142461_(int p_166901_, int p_166902_, int p_166903_, int p_166904_) {
            this.source.m_142461_(p_166901_, p_166902_, p_166903_, p_166904_);
        }

        public void m_141991_() {
            this.source.m_141991_();
        }
    }
}

