/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.BountyTableTileEntity;
import iskallia.vault.block.model.BountyBlockExclamationModel;
import iskallia.vault.block.model.BountyBlockQuestionModel;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.bounty.client.ClientBountyData;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;

public class BountyTableRenderer
implements BlockEntityRenderer<BountyTableTileEntity> {
    private final BountyBlockExclamationModel exclamationPoint;
    private final BountyBlockQuestionModel questionMark;

    public BountyTableRenderer(BlockEntityRendererProvider.Context context) {
        this.exclamationPoint = new BountyBlockExclamationModel(context.m_173582_(BountyBlockExclamationModel.LAYER_LOCATION));
        this.questionMark = new BountyBlockQuestionModel(context.m_173582_(BountyBlockQuestionModel.LAYER_LOCATION));
    }

    public void render(BountyTableTileEntity bountyTable, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        boolean canActivateAvailable;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int tickCount = player.f_19797_;
        BountyList bounties = ClientBountyData.INSTANCE.getBounties();
        BountyList availableBounties = ClientBountyData.INSTANCE.getAvailable();
        boolean bl = canActivateAvailable = bounties.size() < ClientBountyData.getMaxActiveBounties();
        if (ClientBountyData.hasLegendaryBounty()) {
            boolean bl2 = canActivateAvailable = bounties.size() - 1 < ClientBountyData.getMaxActiveBounties();
        }
        if (ClientBountyData.hasCompletedBounty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 2.0 + Math.sin((float)tickCount / 10.0f) / 20.0, 0.5);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)tickCount));
            matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
            VertexConsumer vertexConsumer = BountyBlockQuestionModel.MATERIAL.m_119194_(buffer, RenderType::m_110473_);
            this.questionMark.m_7695_(matrixStack, vertexConsumer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        } else if (canActivateAvailable && !availableBounties.isEmpty() || ClientBountyData.hasLostBountyInInventory() && !ClientBountyData.hasLegendaryBounty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 2.0 + Math.sin((float)tickCount / 10.0f) / 20.0, 0.5);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)tickCount));
            matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
            VertexConsumer vertexConsumer = BountyBlockExclamationModel.MATERIAL.m_119194_(buffer, RenderType::m_110473_);
            this.exclamationPoint.m_7695_(matrixStack, vertexConsumer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        } else if (tickCount % 20 == 0) {
            ClientBountyData.INSTANCE.requestLostBountySearch();
        }
    }
}

