/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector4f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.client.util.color.ColorUtil;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.init.ModRenderTypes;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class ChallengeControllerRenderer
implements BlockEntityRenderer<ChallengeControllerBlockEntity> {
    private final Font font;
    private static final int GLYPH_COUNT = 16;
    private static final int GLYPH_ALPHA = 204;
    private static final float GLYPH_RING_RADIUS = 0.45f;
    private static final float GLYPH_QUAD_SIZE_X = 0.125f;
    private static final float GLYPH_QUAD_SIZE_Y = 0.125f;
    private static final int GLYPH_TEXTURE_GLYPH_WIDTH = 8;
    private static final int GLYPH_TEXTURE_GLYPH_HEIGHT = 8;
    private static final int GLYPH_TEXTURE_WIDTH = 128;
    private static final int GLYPH_TEXTURE_HEIGHT = 40;
    private static final int GLYPH_TEXTURE_COLUMNS = 16;
    private static final float GLYPH_TEXTURE_GLYPH_U = 0.0625f;
    private static final float GLYPH_TEXTURE_GLYPH_V = 0.2f;
    private static final int GLYPH_INDEX_MIN = 3;
    private static final int GLYPH_INDEX_MAX = 60;
    private static final float[] GLYPH_RING_VERTICES = new float[192];

    public ChallengeControllerRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(ChallengeControllerBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        double time = (float)ClientScheduler.INSTANCE.getTick() + partialTick;
        if (entity.getState() == ChallengeControllerBlockEntity.State.IDLE) {
            offsetTime = entity.animationTick;
            for (i = 0; i < 3; ++i) {
                offsetTime += 60.0;
                offsetTime *= 1.2;
                RenderType renderType = RenderType.m_110460_((ResourceLocation)VaultMod.id("textures/particle/challenge_cube.png"), (boolean)true);
                VertexConsumer buffer = bufferSource.m_6299_(renderType);
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 1.65, 0.5);
                poseStack.m_85841_(7.0f, 7.0f, 7.0f);
                poseStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)(offsetTime / 10.0)), (float)0.0f));
                poseStack.m_85845_(Quaternion.m_175228_((float)((float)Math.sin(offsetTime / 20.0)), (float)((float)Math.sin(offsetTime / 40.0)), (float)((float)Math.sin(offsetTime / 20.0))));
                this.renderCube(buffer, poseStack, -1269804976, combinedOverlay);
                poseStack.m_85849_();
            }
        } else if (entity.getState() == ChallengeControllerBlockEntity.State.GENERATING) {
            offsetTime = (float)entity.animationTick + partialTick;
            for (i = 0; i < 3; ++i) {
                offsetTime += 60.0;
                offsetTime *= 1.2;
                RenderType renderType = RenderType.m_110460_((ResourceLocation)VaultMod.id("textures/particle/challenge_cube.png"), (boolean)true);
                VertexConsumer buffer = bufferSource.m_6299_(renderType);
                double progress = Mth.m_14008_((double)(((float)entity.animationTick + partialTick) / 50.0f), (double)0.0, (double)1.0);
                Color color = new Color(ColorUtil.blendColors(entity.getRenderer().getCoreColor(), 0x505050, (float)progress));
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 1.65 + 0.5 * progress, 0.5);
                poseStack.m_85841_(7.0f, 7.0f, 7.0f);
                poseStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)(offsetTime / 10.0)), (float)0.0f));
                poseStack.m_85845_(Quaternion.m_175228_((float)((float)Math.sin(offsetTime / 20.0)), (float)((float)Math.sin(offsetTime / 40.0)), (float)((float)Math.sin(offsetTime / 20.0))));
                this.renderCube(buffer, poseStack, 0xB4000000 | color.getRGB(), combinedOverlay);
                poseStack.m_85849_();
            }
        } else if (entity.getState() == ChallengeControllerBlockEntity.State.ACTIVE) {
            offsetTime = (float)entity.animationTick + partialTick;
            for (i = 0; i < 3; ++i) {
                offsetTime += 60.0;
                offsetTime *= 1.2;
                RenderType renderType = RenderType.m_110460_((ResourceLocation)VaultMod.id("textures/particle/challenge_cube.png"), (boolean)true);
                VertexConsumer buffer = bufferSource.m_6299_(renderType);
                Color color = new Color(entity.getRenderer().getCoreColor());
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 2.15, 0.5);
                poseStack.m_85841_(7.0f, 7.0f, 7.0f);
                poseStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)(offsetTime / 10.0)), (float)0.0f));
                poseStack.m_85845_(Quaternion.m_175228_((float)((float)Math.sin(offsetTime / 20.0)), (float)((float)Math.sin(offsetTime / 40.0)), (float)((float)Math.sin(offsetTime / 20.0))));
                this.renderCube(buffer, poseStack, 0xB4000000 | color.getRGB(), combinedOverlay);
                poseStack.m_85849_();
            }
        }
        if (entity.getState() == ChallengeControllerBlockEntity.State.ACTIVE || entity.getState() == ChallengeControllerBlockEntity.State.GENERATING) {
            poseStack.m_85836_();
            double progress = entity.animationTick == 0 ? 0.0 : Mth.m_14008_((double)(((float)entity.animationTick + partialTick) / 50.0f), (double)0.0, (double)1.0);
            Color color = new Color(ColorUtil.blendColors(entity.getRenderer().getGlyphColor(), 0x505050, (float)progress));
            poseStack.m_85837_(0.5, 1.65 + 0.5 * progress, 0.5);
            this.renderGlyphs(entity, poseStack, bufferSource, entity.animationTick == 0 ? 0.0 : (double)((float)entity.animationTick + partialTick), color.getRGB());
            poseStack.m_85849_();
        }
    }

    private void renderCube(VertexConsumer buffer, PoseStack poseStack, int color, int overlay) {
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        this.putVertex(poseStack, buffer, -0.5f, -0.5f, -0.5f, color, minU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, -0.5f, -0.5f, color, maxU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, -0.5f, 0.5f, color, maxU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, -0.5f, 0.5f, color, minU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, 0.5f, 0.5f, color, minU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, 0.5f, 0.5f, color, maxU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, 0.5f, -0.5f, color, maxU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, 0.5f, -0.5f, color, minU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, -0.5f, 0.5f, color, maxU, minV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, 0.5f, 0.5f, color, maxU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, 0.5f, -0.5f, color, minU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, -0.5f, -0.5f, color, minU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, -0.5f, -0.5f, color, maxU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, 0.5f, -0.5f, color, maxU, maxV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, 0.5f, 0.5f, color, minU, maxV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, -0.5f, 0.5f, color, minU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, -0.5f, -0.5f, color, minU, minV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, -0.5f, -0.5f, color, maxU, minV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, 0.5f, -0.5f, color, maxU, maxV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, 0.5f, -0.5f, color, minU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, -0.5f, 0.5f, color, minU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, -0.5f, 0.5f, color, maxU, minV, overlay);
        this.putVertex(poseStack, buffer, 0.5f, 0.5f, 0.5f, color, maxU, maxV, overlay);
        this.putVertex(poseStack, buffer, -0.5f, 0.5f, 0.5f, color, minU, maxV, overlay);
    }

    public void putVertex(PoseStack matrices, VertexConsumer buffer, float x, float y, float z, int color, float u, float v, int overlay) {
        Matrix4f view = matrices.m_85850_().m_85861_();
        Vector4f pos = new Vector4f(x / 16.0f, y / 16.0f, z / 16.0f, 1.0f);
        pos.m_123607_(view);
        float alpha = (float)(color >>> 24) / 255.0f;
        float red = (float)(color >>> 16 & 0xFF) / 255.0f;
        float green = (float)(color >>> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        buffer.m_5954_(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), red, green, blue, alpha, u, v, overlay, 0, 0.0f, 0.0f, 0.0f);
    }

    private void renderGlyphs(ChallengeControllerBlockEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, double time, int color) {
        VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.TOTEM_GLYPH_EFFECT);
        poseStack.m_85836_();
        poseStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)(time / 10.0)), (float)0.0f));
        poseStack.m_85845_(Quaternion.m_175228_((float)((float)Math.sin(time / 20.0)), (float)((float)Math.sin(time / 40.0)), (float)((float)Math.sin(time / 20.0))));
        int[] glyphIndices = this.getGlyphIndices(entity.m_58899_());
        int alpha = color >>> 24;
        int red = color >>> 16 & 0xFF;
        int green = color >>> 8 & 0xFF;
        int blue = color & 0xFF;
        for (int i = 0; i < 16; ++i) {
            float u0 = (float)(glyphIndices[i] % 16) * 0.0625f;
            float v0 = (float)(glyphIndices[i] / 16) * 0.2f;
            float u1 = (float)(glyphIndices[i] % 16 + 1) * 0.0625f;
            float v1 = (float)(glyphIndices[i] / 16 + 1) * 0.2f;
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 0], GLYPH_RING_VERTICES[i * 3 * 4 + 1], GLYPH_RING_VERTICES[i * 3 * 4 + 2]).m_6122_(red, green, blue, alpha).m_7421_(u0, v0).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 3], GLYPH_RING_VERTICES[i * 3 * 4 + 4], GLYPH_RING_VERTICES[i * 3 * 4 + 5]).m_6122_(red, green, blue, alpha).m_7421_(u0, v1).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 6], GLYPH_RING_VERTICES[i * 3 * 4 + 7], GLYPH_RING_VERTICES[i * 3 * 4 + 8]).m_6122_(red, green, blue, alpha).m_7421_(u1, v1).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 9], GLYPH_RING_VERTICES[i * 3 * 4 + 10], GLYPH_RING_VERTICES[i * 3 * 4 + 11]).m_6122_(red, green, blue, alpha).m_7421_(u1, v0).m_85969_(0xF000F0).m_5752_();
        }
        poseStack.m_85849_();
    }

    private int[] getGlyphIndices(BlockPos pos) {
        ChunkRandom random = ChunkRandom.any();
        random.setBlockSeed(0L, pos, 374761393L);
        int[] result = new int[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = random.nextInt(3, 61);
        }
        return result;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            double radians = 0.39269908169872414 * (double)i;
            float xCenter = (float)Math.cos(radians) * 0.45f;
            float zCenter = (float)Math.sin(radians) * 0.45f;
            Vec2 center = new Vec2(xCenter, zCenter);
            Vec2 perpendicular = new Vec2(zCenter, -xCenter).m_165902_().m_165903_(0.125f);
            Vec2 c0 = center.m_165910_(perpendicular);
            Vec2 c1 = center.m_165910_(perpendicular.m_165913_());
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 0] = c0.f_82470_;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 1] = 0.125f;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 2] = c0.f_82471_;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 3] = c0.f_82470_;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 4] = -0.125f;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 5] = c0.f_82471_;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 6] = c1.f_82470_;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 7] = -0.125f;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 8] = c1.f_82471_;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 9] = c1.f_82470_;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 10] = 0.125f;
            ChallengeControllerRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 11] = c1.f_82471_;
        }
    }
}

