/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.CompanionHomeTileEntity;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.overlay.ModifiersRenderer;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.item.CompanionItem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CompanionHomeRenderer
implements BlockEntityRenderer<CompanionHomeTileEntity> {
    private final EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
    private final Font font;

    public CompanionHomeRenderer(BlockEntityRendererProvider.Context context) {
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void render(CompanionHomeTileEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemStack companion = tile.getCompanion();
        if (companion.m_41619_()) {
            return;
        }
        PetEntity pet = tile.getRenderPet();
        if (pet != null) {
            this.renderPet(pet, tile, partialTicks, poseStack, buffer, packedLight);
            this.renderNameTag(pet, tile, poseStack, buffer, packedLight);
        }
    }

    private void renderPet(PetEntity pet, CompanionHomeTileEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        pet.f_19794_ = true;
        pet.setSleeping(false);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.4, 0.5);
        Direction facing = (Direction)tile.m_58900_().m_61143_((Property)FacedBlock.FACING);
        float rotation = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            case Direction.WEST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        float yBodyRot = pet.f_20883_;
        float yBodyRotO = pet.f_20884_;
        float yRot = pet.m_146908_();
        float xRot = pet.m_146909_();
        float yHeadRotO = pet.f_20886_;
        float yHeadRot = pet.f_20885_;
        pet.f_20883_ = 0.0f;
        pet.f_20884_ = 0.0f;
        pet.m_146922_(0.0f);
        pet.m_146926_(0.0f);
        pet.f_19860_ = 0.0f;
        pet.f_20885_ = pet.m_146908_();
        pet.f_20886_ = pet.m_146908_();
        int level = CompanionItem.getCompanionLevel(tile.getCompanion());
        String type = CompanionItem.getPetType(tile.getCompanion());
        if (type != null && !type.equalsIgnoreCase("giant") && !type.equalsIgnoreCase("eternal")) {
            float levelScale = 1.0f + (float)(level - 1) * 0.05f;
            poseStack.m_85841_(levelScale, levelScale, levelScale);
        }
        this.dispatcher.m_114384_((Entity)pet, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, buffer, packedLight);
        pet.f_20883_ = yBodyRot;
        pet.f_20884_ = yBodyRotO;
        pet.m_146922_(yRot);
        pet.m_146926_(xRot);
        pet.f_20886_ = yHeadRotO;
        pet.f_20885_ = yHeadRot;
        poseStack.m_85849_();
    }

    private void renderCooldownDisplay(ItemStack companion, CompanionHomeTileEntity tile, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!(companion.m_41720_() instanceof CompanionItem)) {
            return;
        }
        int currentCooldown = CompanionItem.getCurrentCooldown(companion);
        List<MutableComponent> text = CompanionItem.getCompanionHearts(companion) <= 0 ? List.of(new TextComponent("Retired").m_130940_(ChatFormatting.WHITE)) : (currentCooldown <= 0 ? List.of(new TextComponent("Ready!").m_130940_(ChatFormatting.GREEN)) : List.of(new TextComponent("Resting").m_130940_(ChatFormatting.WHITE), new TextComponent(UIHelper.formatTimeString((long)currentCooldown * 20L)).m_130940_(ChatFormatting.WHITE)));
        Direction facing = (Direction)tile.m_58900_().m_61143_((Property)FacedBlock.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.36, 0.5);
        float rotation = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            case Direction.WEST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        poseStack.m_85837_(0.0, -0.05, 0.51);
        poseStack.m_85841_(0.01f, -0.01f, 0.01f);
        float maxWidth = text.stream().mapToInt(arg_0 -> ((Font)this.font).m_92852_(arg_0)).max().orElse(0);
        float offset = -maxWidth / 2.0f;
        for (int i = 0; i < text.size(); ++i) {
            Component line = (Component)text.get(i);
            float lineOffset = (maxWidth - (float)this.font.m_92852_((FormattedText)line)) / 2.0f;
            Objects.requireNonNull(this.font);
            this.font.m_92763_(poseStack, line, offset + lineOffset, (float)(i * 9), -12698050);
        }
        poseStack.m_85849_();
    }

    private void renderNameTag(PetEntity pet, CompanionHomeTileEntity tile, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!pet.m_8077_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        if (!result.m_82425_().equals((Object)tile.m_58899_())) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(mc.m_91290_().m_114470_());
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85841_(0.01f, 0.01f, 0.01f);
        Component displayName = pet.m_5446_();
        float width = this.font.m_92852_((FormattedText)displayName);
        this.font.m_92841_(displayName, -width / 2.0f, 0.0f, 0xFFFFFF, false, poseStack.m_85850_().m_85861_(), buffer, false, 0, packedLight);
        Optional<VaultModifierStack> stack = CompanionItem.getTemporalModifier(tile.getCompanion()).map(VaultModifierRegistry::getOpt).map(modifier -> modifier.map(VaultModifierStack::of).orElse(null));
        stack.ifPresent(vaultModifierStack -> {
            RenderSystem.m_69482_();
            poseStack.m_85836_();
            Minecraft minecraft = Minecraft.m_91087_();
            int right = minecraft.m_91268_().m_85445_();
            int bottom = minecraft.m_91268_().m_85446_();
            poseStack.m_85837_((double)(-right), (double)(-bottom), 0.0);
            poseStack.m_85837_((double)(width / 2.0f - 8.0f), 0.0, 0.0);
            ModifiersRenderer.renderVaultModifiersWithDepth(List.of(vaultModifierStack), poseStack, false);
            poseStack.m_85849_();
        });
        poseStack.m_85849_();
    }
}

