/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.block.FinalVaultFrameBlock;
import iskallia.vault.block.VaultPortalBlock;
import iskallia.vault.block.VaultPortalSize;
import iskallia.vault.block.entity.FinalVaultFrameTileEntity;
import iskallia.vault.client.util.LightmapUtil;
import iskallia.vault.entity.model.StatuePlayerModel;
import iskallia.vault.init.ModShaders;
import iskallia.vault.util.McClientHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FinalVaultFrameRenderer
implements BlockEntityRenderer<FinalVaultFrameTileEntity> {
    public static StatuePlayerModel PLAYER_MODEL;
    private static final Map<BlockPos, Long> PARTICLE_SPAWN_TIMESTAMPS;

    public FinalVaultFrameRenderer(BlockEntityRendererProvider.Context context) {
        PLAYER_MODEL = new StatuePlayerModel(context);
    }

    public void render(@Nonnull FinalVaultFrameTileEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        long prevTime;
        long now;
        long dt;
        boolean portalFormed;
        ClientLevel world = (ClientLevel)tileEntity.m_58904_();
        if (world == null) {
            return;
        }
        boolean ownerOnline = McClientHelper.getOnlineProfile(tileEntity.getOwnerUUID()).map(GameProfile::getId).filter(uuid -> uuid.equals(tileEntity.getOwnerUUID())).isPresent();
        ResourceLocation skinLocation = tileEntity.getSkin().getLocationSkin();
        RenderType renderType = PLAYER_MODEL.m_103119_(skinLocation);
        VertexConsumer vertexBuilder = buffer.m_6299_(renderType);
        BlockPos blockPos = tileEntity.m_58899_();
        BlockState blockState = tileEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)FinalVaultFrameBlock.FACING);
        matrixStack.m_85836_();
        Color color = new Color(-6646101);
        ModShaders.getColorizePositionTexShader().withColorize((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f).withBrightness(LightmapUtil.getLightmapBrightness(combinedLight)).withGrayscale(ownerOnline ? 0.45f : 1.0f).enable();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122435_() + 180.0f));
        float headScale = 0.75f;
        matrixStack.m_85841_(headScale, headScale, 1.0f);
        matrixStack.m_85837_(0.0, -0.25, (double)-0.275f);
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        FinalVaultFrameRenderer.PLAYER_MODEL.f_102809_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        FinalVaultFrameRenderer.PLAYER_MODEL.f_102808_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).m_109912_(renderType);
        }
        boolean bl = portalFormed = VaultPortalSize.getPortalSize((LevelAccessor)world, blockPos.m_142127_(), Direction.Axis.Z, VaultPortalBlock.FRAME).isPresent() || VaultPortalSize.getPortalSize((LevelAccessor)world, blockPos.m_142128_(), Direction.Axis.Z, VaultPortalBlock.FRAME).isPresent() || VaultPortalSize.getPortalSize((LevelAccessor)world, blockPos.m_142125_(), Direction.Axis.X, VaultPortalBlock.FRAME).isPresent() || VaultPortalSize.getPortalSize((LevelAccessor)world, blockPos.m_142126_(), Direction.Axis.X, VaultPortalBlock.FRAME).isPresent();
        if (portalFormed && (dt = (now = System.currentTimeMillis()) - (prevTime = PARTICLE_SPAWN_TIMESTAMPS.computeIfAbsent(blockPos, p -> now).longValue())) >= 300L && world.f_46441_.nextBoolean()) {
            FinalVaultFrameRenderer.addFlameParticle(world, blockPos, direction, 0.375f);
            FinalVaultFrameRenderer.addFlameParticle(world, blockPos, direction, -0.375f);
            PARTICLE_SPAWN_TIMESTAMPS.put(blockPos, now);
        }
        matrixStack.m_85849_();
    }

    private static void addFlameParticle(ClientLevel world, BlockPos blockPos, Direction direction, float offset) {
        float x = (float)blockPos.m_123341_() + 0.5f + (float)direction.m_122429_() * 0.625f;
        float y = (float)blockPos.m_123342_() + 0.8125f;
        float z = (float)blockPos.m_123343_() + 0.5f + (float)direction.m_122431_() * 0.625f;
        if (direction.m_122434_() == Direction.Axis.Z) {
            x += offset;
        }
        if (direction.m_122434_() == Direction.Axis.X) {
            z += offset;
        }
        float xSpeed = 0.0f;
        float ySpeed = 0.01f;
        float zSpeed = 0.0f;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)x, (double)y, (double)z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
    }

    static {
        PARTICLE_SPAWN_TIMESTAMPS = new HashMap<BlockPos, Long>();
    }
}

