/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.GateLockBlock;
import iskallia.vault.block.entity.GateLockTileEntity;
import iskallia.vault.client.ClientStatisticsData;
import iskallia.vault.config.VaultModifierOverlayConfig;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.overlay.ModifiersRenderer;
import iskallia.vault.init.ModConfigs;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class GateLockRenderer
implements BlockEntityRenderer<GateLockTileEntity> {
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Font font;
    private final ItemRenderer itemRenderer;

    public GateLockRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
    }

    public void render(GateLockTileEntity entity, float pPartialTick, PoseStack matrices, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (entity.getGod() == null) {
            return;
        }
        BlockState blockstate = entity.m_58900_();
        matrices.m_85836_();
        float f = 0.6666667f;
        Vec3i vector = ((Direction)blockstate.m_61143_((Property)GateLockBlock.FACING)).m_122436_();
        matrices.m_85837_(0.5 + 0.9 * (double)vector.m_123341_(), 0.5 + 0.9 * (double)vector.m_123342_(), 0.5 + 0.9 * (double)vector.m_123343_());
        float f4 = -((Direction)blockstate.m_61143_((Property)GateLockBlock.FACING)).m_122435_();
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(f4));
        matrices.m_85837_(0.0, -0.3125, -0.4375);
        matrices.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrices.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        matrices.m_85836_();
        matrices.m_85836_();
        matrices.m_85841_(2.0f, 2.0f, 2.0f);
        this.renderLine((Component)new TextComponent(entity.getName()).m_130948_(Style.f_131099_.m_178520_(entity.getColor())), true, matrices, pBufferSource, pPackedLight);
        matrices.m_85849_();
        Minecraft minecraft = Minecraft.m_91087_();
        List<ItemStack> items = minecraft.f_91074_.f_36095_.m_38927_().stream().map(ItemStack::m_41777_).toList();
        int count = entity.getModifiers().size();
        if (count > 0) {
            matrices.m_85837_(0.0, 30.0, 0.0);
            matrices.m_85836_();
            int right = minecraft.m_91268_().m_85445_();
            int bottom = minecraft.m_91268_().m_85446_();
            matrices.m_85837_((double)(-right), (double)(-bottom), 0.0);
            VaultModifierOverlayConfig vaultModifierOverlayConfig = ModConfigs.VAULT_MODIFIER_OVERLAY;
            matrices.m_85837_((double)vaultModifierOverlayConfig.spacingX + (double)((vaultModifierOverlayConfig.size + vaultModifierOverlayConfig.spacingX) * count) / 2.0, 0.0, 0.0);
            ModifiersRenderer.renderVaultModifiers(entity.getModifiers(), matrices);
            matrices.m_85849_();
        }
        AtomicInteger index = new AtomicInteger(1);
        for (VaultModifierStack vaultModifierStack : entity.getModifiers()) {
            VaultModifierRegistry.getOpt(vaultModifierStack.getModifierId()).ifPresent(modifier -> {
                matrices.m_85836_();
                matrices.m_85837_(0.0, 10.0 * (double)index.get(), 0.0);
                this.renderLine(modifier.getChatDisplayNameComponent(stack.getSize()), true, matrices, pBufferSource, pPackedLight);
                matrices.m_85849_();
                index.getAndIncrement();
            });
        }
        if (entity.getReputationCost() > 0) {
            matrices.m_85837_(0.0, 10.0 * (double)index.get(), 0.0);
            matrices.m_85836_();
            int reputation = ClientStatisticsData.getReputation(entity.getGod());
            ChatFormatting chatFormatting = reputation >= entity.getReputationCost() ? ChatFormatting.WHITE : ChatFormatting.RED;
            this.renderLine((Component)new TextComponent("").m_7220_((Component)new TextComponent(entity.getReputationCost() + " ").m_130940_(chatFormatting)).m_7220_((Component)new TextComponent(entity.getGod().getName()).m_130940_(entity.getGod().getChatColor())).m_7220_((Component)new TextComponent(" Reputation").m_130940_(chatFormatting)), true, matrices, pBufferSource, pPackedLight);
            matrices.m_85849_();
        }
        for (ItemStack itemStack : entity.getCost()) {
            matrices.m_85837_(0.0, 45.0, 0.0);
            ChatFormatting color = this.check(items, itemStack.m_41777_(), true) && this.check(items, itemStack.m_41777_(), false) ? ChatFormatting.WHITE : ChatFormatting.RED;
            this.renderItemLine(itemStack, (Component)itemStack.m_41786_().m_6881_().m_130940_(color), (Component)new TextComponent((itemStack.m_41613_() < 10 ? " " : "") + itemStack.m_41613_()).m_130940_(color), true, matrices, pBufferSource, pPackedLight);
        }
        matrices.m_85849_();
        matrices.m_85849_();
    }

    private boolean check(List<ItemStack> items, ItemStack stack, boolean simulate) {
        int deductedAmount = 0;
        for (ItemStack plStack : items) {
            if (stack.m_41613_() <= 0) {
                return true;
            }
            if (!GateLockRenderer.isEqualCrafting(stack, plStack)) continue;
            stack.m_41774_(deductedAmount += Math.min(stack.m_41613_(), plStack.m_41613_()));
            if (simulate) continue;
            plStack.m_41774_(deductedAmount);
        }
        return false;
    }

    private static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return thisStack.m_41720_() == thatStack.m_41720_() && thisStack.m_41773_() == thatStack.m_41773_() && (thisStack.m_41783_() == null || thisStack.areShareTagsEqual(thatStack));
    }

    public void renderLine(Component component, boolean centered, PoseStack matrices, MultiBufferSource source, int light) {
        float f;
        float offsetX;
        FormattedCharSequence formatted = (FormattedCharSequence)this.font.m_92923_((FormattedText)component, 9000).get(0);
        float f2 = offsetX = centered ? (float)((double)(-this.font.m_92724_(formatted)) / 2.0) : 0.0f;
        if (centered) {
            Objects.requireNonNull(this.font);
            f = (float)((double)(-9) / 2.0);
        } else {
            f = 0.0f;
        }
        float offsetY = f;
        RenderSystem.m_69482_();
        this.font.m_92733_(formatted, offsetX, offsetY, 0xFFFFFF, false, matrices.m_85850_().m_85861_(), source, true, 0, light);
        RenderSystem.m_69482_();
        this.font.m_92733_(formatted, offsetX, offsetY, -1, false, matrices.m_85850_().m_85861_(), source, false, 0, light);
    }

    public void renderItemLine(ItemStack stack, Component text, Component count, boolean centered, PoseStack matrices, MultiBufferSource source, int light) {
        float f;
        float offsetX;
        FormattedCharSequence formatted = (FormattedCharSequence)this.font.m_92923_((FormattedText)text, 9000).get(0);
        float f2 = offsetX = centered ? (float)((double)(-this.font.m_92724_(formatted)) / 2.0) + 15.0f : 0.0f;
        if (centered) {
            Objects.requireNonNull(this.font);
            f = (float)((double)(-9) / 2.0);
        } else {
            f = 0.0f;
        }
        float offsetY = f;
        RenderSystem.m_69482_();
        this.font.m_92733_(formatted, offsetX, offsetY, 0xFFFFFF, false, matrices.m_85850_().m_85861_(), source, true, 0, light);
        RenderSystem.m_69482_();
        this.font.m_92733_(formatted, offsetX, offsetY, -1, false, matrices.m_85850_().m_85861_(), source, false, 0, light);
        matrices.m_85836_();
        matrices.m_85837_((double)(offsetX - 18.0f), -2.0, (double)-0.4f);
        matrices.m_85841_(24.0f, -24.0f, 1.0f);
        this.itemRenderer.m_174269_(stack, ItemTransforms.TransformType.GUI, light, OverlayTexture.f_118083_, matrices, source, light);
        matrices.m_85841_(1.0f, -1.0f, 0.4f);
        matrices.m_85837_(0.0, 0.0, (double)0.2f);
        formatted = (FormattedCharSequence)this.font.m_92923_((FormattedText)count, 9000).get(0);
        matrices.m_85841_(0.045454547f, 0.045454547f, 1.0f);
        RenderSystem.m_69482_();
        this.font.m_92733_(formatted, 1.0f, offsetY + 8.0f, 0xFFFFFF, false, matrices.m_85850_().m_85861_(), source, true, 0, light);
        RenderSystem.m_69482_();
        this.font.m_92733_(formatted, 1.0f, offsetY + 8.0f, -1, false, matrices.m_85850_().m_85861_(), source, false, 0, light);
        matrices.m_85849_();
    }

    private static int getDarkColor(GateLockTileEntity pBlockEntity) {
        int i = 0xFFFFFF;
        boolean glowing = false;
        double d0 = 0.4;
        int j = (int)((double)NativeImage.m_85085_((int)i) * 1.0);
        int k = (int)((double)NativeImage.m_85103_((int)i) * 1.0);
        int l = (int)((double)NativeImage.m_85119_((int)i) * 1.0);
        return i == DyeColor.BLACK.m_41071_() && glowing ? -988212 : NativeImage.m_84992_((int)0, (int)l, (int)k, (int)j);
    }

    private static boolean isOutlineVisible(GateLockTileEntity pBlockEntity, int pTextColor) {
        if (pTextColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)pBlockEntity.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }
}

