/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.base.GodAltarBlock;
import iskallia.vault.block.base.GodAltarTileEntity;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.task.renderer.context.GodAltarRendererContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class GodAltarRenderer
implements BlockEntityRenderer<GodAltarTileEntity> {
    private final Font font;
    private static final double MAX_RENDER_DISTANCE_SQ = 49.0;

    public GodAltarRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(GodAltarTileEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlayIn) {
        Vec3 blockCenter;
        Vec3 playerPos;
        double distanceSq;
        if (tileEntity.isCompleted()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        BlockPos blockPos = tileEntity.m_58899_();
        if (tileEntity.getTask() == null && (distanceSq = (playerPos = player.m_20299_(partialTicks)).m_82557_(blockCenter = Vec3.m_82512_((Vec3i)blockPos))) > 49.0) {
            return;
        }
        RenderSystem.m_69482_();
        matrixStack.m_85836_();
        float scale = 0.012f;
        matrixStack.m_85837_(0.5, 2.1, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-65.0, -11.0, 0.0);
        GodAltarRendererContext context = GodAltarRendererContext.forWorld(matrixStack, partialTicks, this.font);
        if (tileEntity.getTask() != null) {
            tileEntity.getTask().onRender(context);
        } else {
            VaultGod god = (VaultGod)((Object)tileEntity.m_58900_().m_61143_(GodAltarBlock.GOD));
            context.renderTimerBar(god, "Waiting for activation");
            context.renderHeader(this.extractTitleFromNBT(tileEntity), true);
        }
        matrixStack.m_85849_();
    }

    private String extractTitleFromNBT(GodAltarTileEntity tileEntity) {
        CompoundTag renderer;
        CompoundTag taskPool;
        CompoundTag nbt = tileEntity.m_187482_();
        if (nbt.m_128441_("taskPool") && (taskPool = nbt.m_128469_("taskPool")).m_128441_("renderer") && (renderer = taskPool.m_128469_("renderer")).m_128441_("title")) {
            return renderer.m_128461_("title");
        }
        return "Unknown Task";
    }
}

