/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.block.entity.GridGatewayTileEntity;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class GridGatewayRenderer
implements BlockEntityRenderer<GridGatewayTileEntity> {
    private final BlockRenderDispatcher brd;

    public GridGatewayRenderer(BlockEntityRendererProvider.Context context) {
        this.brd = context.m_173584_();
    }

    public void render(GridGatewayTileEntity tile, float pPartialTick, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        BlockState state = tile.m_58900_();
        BakedModel bakedmodel = this.brd.m_110910_(state);
        VertexConsumer buf = buffers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false));
        bakedmodel.getQuads(state, null, tile.m_58904_().m_5822_(), (IModelData)EmptyModelData.INSTANCE).forEach(quad -> this.putQuadData(tile, buf, poseStack.m_85850_(), (BakedQuad)quad, packedLight, packedOverlay));
    }

    private void putQuadData(GridGatewayTileEntity tile, VertexConsumer vertexConsumer, PoseStack.Pose pose, BakedQuad quad, int packedLight, int pPackedOverlay) {
        float blue;
        float green;
        float red;
        if (quad.m_111304_()) {
            int i = tile.getTintColor(quad.m_111305_(), tile);
            red = (float)(i >> 16 & 0xFF) / 255.0f;
            green = (float)(i >> 8 & 0xFF) / 255.0f;
            blue = (float)(i & 0xFF) / 255.0f;
        } else {
            red = 1.0f;
            green = 1.0f;
            blue = 1.0f;
        }
        vertexConsumer.m_85995_(pose, quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, new int[]{packedLight, packedLight, packedLight, packedLight}, pPackedOverlay, true);
    }
}

