/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.HourglassTileEntity;
import iskallia.vault.client.util.RenderTypeDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;

public class HourglassRenderer
implements BlockEntityRenderer<HourglassTileEntity> {
    private static final ResourceLocation SAND_TEXTURE = VaultMod.id("textures/block/hourglass_sand.png");
    private static List<AABB> SAND_BOXES = new ArrayList<AABB>();
    private static final int totalHeight;

    public HourglassRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HourglassTileEntity te, float partialTicks, PoseStack renderStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        ModelPart sandBoxes = this.prepareSandRender(te.getFilledPercentage());
        RenderTypeDecorator wrapped = RenderTypeDecorator.decorate(RenderType.m_110451_(), () -> GlStateManager.m_84544_((int)Minecraft.m_91087_().m_91097_().m_118506_(SAND_TEXTURE).m_117963_()), () -> RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_));
        RenderType other = RenderType.m_110446_((ResourceLocation)SAND_TEXTURE);
        renderStack.m_85836_();
        renderStack.m_85837_(0.01, 0.125, 0.01);
        renderStack.m_85841_(0.98f, 1.0f, 0.98f);
        VertexConsumer vb = buffers.m_6299_((RenderType)wrapped);
        renderStack.m_85849_();
        buffers.m_6299_(RenderType.m_110504_());
    }

    private ModelPart prepareSandRender(float percentage) {
        float heightPart = (float)totalHeight * Mth.m_14036_((float)percentage, (float)0.0f, (float)1.0f);
        for (AABB box : SAND_BOXES) {
            float ySize = (float)box.m_82376_();
            float remainingHeight = heightPart - ySize;
            if (remainingHeight >= 0.0f) {
                heightPart = (float)((double)heightPart - box.m_82376_());
                continue;
            }
            float part = heightPart / ySize;
            break;
        }
        return null;
    }

    private static void shiftY(float y) {
        SAND_BOXES = SAND_BOXES.stream().map(box -> box.m_82386_(0.0, (double)y, 0.0)).collect(Collectors.toList());
    }

    private static AABB makeBox(double x, double y, double z, double width, double height, double depth) {
        return new AABB(x, y, z, x + width, y + height, z + depth);
    }

    static {
        SAND_BOXES.add(HourglassRenderer.makeBox(2.0, 0.0, 2.0, 12.0, 7.0, 12.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(3.0, 7.0, 3.0, 10.0, 3.0, 10.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(4.0, 10.0, 4.0, 8.0, 2.0, 8.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(5.0, 12.0, 5.0, 6.0, 1.0, 6.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(6.0, 13.0, 6.0, 4.0, 1.0, 4.0));
        HourglassRenderer.shiftY(-0.02f);
        SAND_BOXES.add(HourglassRenderer.makeBox(6.0, 14.0, 6.0, 4.0, 1.0, 4.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(5.0, 15.0, 5.0, 6.0, 1.0, 6.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(4.0, 16.0, 4.0, 8.0, 2.0, 8.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(3.0, 18.0, 3.0, 10.0, 3.0, 10.0));
        SAND_BOXES.add(HourglassRenderer.makeBox(2.0, 21.0, 2.0, 12.0, 7.0, 12.0));
        HourglassRenderer.shiftY(0.01f);
        totalHeight = 28;
    }
}

