/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.LootStatueBlock;
import iskallia.vault.block.entity.LootStatueTileEntity;
import iskallia.vault.entity.model.StatuePlayerModel;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.SkinProfile;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;

public class LootStatueRenderer
implements BlockEntityRenderer<LootStatueTileEntity> {
    protected static StatuePlayerModel PLAYER_MODEL;
    private final Minecraft mc = Minecraft.m_91087_();
    private final BlockRenderDispatcher blockRenderer = this.mc.m_91289_();
    private final ItemRenderer itemRenderer = this.mc.m_91291_();
    private static final ResourceLocation STONE_SKIN;

    public LootStatueRenderer(BlockEntityRendererProvider.Context context) {
        PLAYER_MODEL = new StatuePlayerModel(context);
    }

    public void render(LootStatueTileEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack loot;
        BlockState blockState = tileEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)LootStatueBlock.FACING);
        LootStatueRenderer.renderBlockState(tileEntity.getStand(), matrixStack, buffer, this.blockRenderer, tileEntity.m_58904_(), tileEntity.m_58899_());
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122435_() + 180.0f));
        if (tileEntity.getChipCount() > 0 && this.mc.f_91074_ != null) {
            matrixStack.m_85836_();
            LocalPlayer player = this.mc.f_91074_;
            int lightLevel = this.getLightAtPos(tileEntity.m_58904_(), tileEntity.m_58899_().m_7494_());
            matrixStack.m_85837_(0.0, 0.25, 0.25);
            matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(-direction.m_122435_() - 180.0f));
            this.renderItemWithLabel(new ItemStack((ItemLike)ModItems.ACCELERATION_CHIP), (Player)player, matrixStack, buffer, combinedOverlay, lightLevel, new TextComponent(String.valueOf(tileEntity.getChipCount())), -1);
            matrixStack.m_85849_();
        }
        if (!(loot = tileEntity.getLootItem()).m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 1.25, 0.35);
            BakedModel bakedmodel = this.itemRenderer.m_174264_(loot, null, null, 0);
            float scale = bakedmodel.m_7539_() ? 1.25f : 0.8f;
            matrixStack.m_85841_(scale, scale, scale);
            this.itemRenderer.m_115143_(loot, ItemTransforms.TransformType.FIXED, false, matrixStack, buffer, combinedLight, combinedOverlay, bakedmodel);
            matrixStack.m_85849_();
        }
        this.drawPlayerModel(matrixStack, buffer, tileEntity, combinedLight, combinedOverlay, partialTicks);
        String latestNickname = tileEntity.getSkin().getLatestNickname();
        if (StringUtil.m_14408_((String)latestNickname)) {
            return;
        }
        this.drawStatueNameplate(matrixStack, buffer, latestNickname, direction, tileEntity, combinedLight, combinedOverlay);
    }

    private void drawStatueNameplate(PoseStack matrixStack, MultiBufferSource buffer, String latestNickname, Direction direction, LootStatueTileEntity tileEntity, int combinedLight, int combinedOverlay) {
        FormattedCharSequence text = new TextComponent(latestNickname).m_130940_(ChatFormatting.GRAY).m_7532_();
        Font fr = this.mc.f_91065_.m_93082_();
        int xOffset = fr.m_92724_(text);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.25, 0.51);
        matrixStack.m_85841_(0.011f, -0.011f, 0.011f);
        float f = (float)(-xOffset) / 2.0f;
        Objects.requireNonNull(fr);
        fr.m_92733_(text, f, (float)(-9) / 2.0f, -65536, true, matrixStack.m_85850_().m_85861_(), buffer, true, 0, combinedLight);
        matrixStack.m_85849_();
    }

    private void drawStatueCrownHat(PoseStack matrixStack, MultiBufferSource buffer, Direction direction, int combinedLight, int combinedOverlay) {
        float crownScale = 3.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 2.5, 0.0);
        matrixStack.m_85841_(crownScale, crownScale, crownScale);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)this.mc.f_91074_.f_19797_));
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.MVP_CROWN);
        BakedModel ibakedmodel = this.mc.m_91291_().m_174264_(stack, null, null, 0);
        this.mc.m_91291_().m_115143_(stack, ItemTransforms.TransformType.GROUND, true, matrixStack, buffer, combinedLight, combinedOverlay, ibakedmodel);
        matrixStack.m_85849_();
    }

    private void drawPlayerModel(PoseStack matrixStack, MultiBufferSource buffer, LootStatueTileEntity tileEntity, int combinedLight, int combinedOverlay, float partialTicks) {
        BlockState blockState = tileEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)LootStatueBlock.FACING);
        SkinProfile skin = tileEntity.getSkin();
        ResourceLocation skinLocation = StringUtil.m_14408_((String)skin.getLatestNickname()) ? STONE_SKIN : skin.getLocationSkin();
        RenderType renderType = PLAYER_MODEL.m_103119_(skinLocation);
        LootStatueRenderer.PLAYER_MODEL.f_102610_ = false;
        LootStatueRenderer.PLAYER_MODEL.f_102812_.f_104203_ = -120.0f;
        LootStatueRenderer.PLAYER_MODEL.f_103374_.f_104203_ = -120.0f;
        LootStatueRenderer.PLAYER_MODEL.f_102811_.f_104203_ = -120.0f;
        LootStatueRenderer.PLAYER_MODEL.f_103375_.f_104203_ = -120.0f;
        PLAYER_MODEL.setSlim(skin.isSlim());
        int wobble = tileEntity.getWobbleTime();
        if (wobble != 0) {
            float angle;
            float w;
            float x = w = (float)wobble + (1.0f - partialTicks);
            LootStatueRenderer.PLAYER_MODEL.f_102808_.f_104205_ = angle = (float)((double)(0.1f * Mth.m_14031_((float)x)) * (Math.exp(0.05 * (double)x) - 1.0));
            LootStatueRenderer.PLAYER_MODEL.f_102809_.f_104205_ = angle;
        } else {
            LootStatueRenderer.PLAYER_MODEL.f_102808_.f_104205_ = 0.0f;
            LootStatueRenderer.PLAYER_MODEL.f_102809_.f_104205_ = 0.0f;
        }
        VertexConsumer vertexBuilder = buffer.m_6299_(renderType);
        float scale = 1.25f;
        float statueOffset = -0.125f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, (double)statueOffset);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85837_(0.0, -1.5, 0.0);
        PLAYER_MODEL.m_7695_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        if (buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).m_109912_(renderType);
        }
    }

    private void renderItemWithLabel(ItemStack stack, Player player, PoseStack matrixStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel, TextComponent text, int color) {
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-player.m_146908_()));
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        this.itemRenderer.m_174269_(stack, ItemTransforms.TransformType.GROUND, lightLevel, combinedOverlay, matrixStack, buffer, 0);
        float scale = -0.025f;
        float offset = -Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2;
        matrixStack.m_85837_(0.0, 0.75, 0.0);
        matrixStack.m_85841_(scale, scale, scale);
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        Minecraft.m_91087_().f_91062_.m_92841_((Component)text, offset, 0.0f, color, false, matrix4f, buffer, false, 0, lightLevel);
        matrixStack.m_85849_();
    }

    private int getLightAtPos(Level world, BlockPos pos) {
        int blockLight = world.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = world.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }

    private static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                LootStatueRenderer.renderBlockState(state, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderType((RenderType)type);
        blockRenderer.m_110937_().m_111047_((BlockAndTintGetter)world, blockRenderer.m_110910_(state), state, pos, matrixStack, buffer.m_6299_(type), false, world.f_46441_, 0L, OverlayTexture.f_118083_);
        ForgeHooksClient.setRenderType(null);
    }

    static {
        STONE_SKIN = VaultMod.id("textures/entity/stoneskin.png");
    }
}

