/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.PersonalVaultBlock;
import iskallia.vault.block.entity.PersonalVaultTileEntity;
import iskallia.vault.init.ModItems;
import iskallia.vault.world.data.PersonalVaultData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PersonalVaultRenderer
implements BlockEntityRenderer<PersonalVaultTileEntity> {
    public PersonalVaultRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PersonalVaultTileEntity tile, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        UUID playerId = mc.f_91074_.m_142081_();
        PersonalVaultData.Entry entry = PersonalVaultData.CLIENT.getOrCreate(playerId);
        Direction dir = (Direction)tile.m_58900_().m_61143_((Property)PersonalVaultBlock.FACING);
        for (int row = -1; row <= 1; ++row) {
            for (int col = -1; col <= 1; ++col) {
                int r = 4 + row;
                int c = 4 + col;
                int slot = r * 9 + c;
                ItemStack stack = ItemStack.f_41583_;
                PersonalVaultData.Entry.SlotStatus status = entry.getSlotStatus(slot);
                if (status == PersonalVaultData.Entry.SlotStatus.FILLED) {
                    stack = entry.getSlotItems().getOrDefault(slot, ItemStack.f_41583_);
                } else if (status == PersonalVaultData.Entry.SlotStatus.ROCK) {
                    stack = new ItemStack((ItemLike)ModItems.VAULT_ROCK);
                }
                if (stack.m_41619_()) continue;
                matrixStack.m_85836_();
                this.renderInscription(matrixStack, buffer, combinedLight, combinedOverlay, 0.487f, 0.18f, stack, dir, row, col);
                matrixStack.m_85849_();
            }
        }
    }

    private void renderInscription(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, int overlay, float yOffset, float scale, ItemStack itemStack, Direction dir, int row, int col) {
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85837_(0.5, (double)yOffset, 0.5);
        int rot = 0;
        if (dir == Direction.WEST) {
            rot = 270;
        }
        if (dir == Direction.NORTH) {
            rot = 180;
        }
        if (dir == Direction.EAST) {
            rot = 90;
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)rot));
        float spacing = 0.25f;
        matrixStack.m_85837_((double)((float)(-col) * spacing), 0.0, (double)((float)(-row) * spacing));
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.01, 0.0);
        BakedModel model = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, true, matrixStack, buffer, lightLevel, overlay, model);
    }
}

