/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import iskallia.vault.block.RelicPedestalBlock;
import iskallia.vault.block.entity.RelicPedestalTileEntity;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModRelics;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RelicPedestalRenderer
implements BlockEntityRenderer<RelicPedestalTileEntity> {
    public RelicPedestalRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RelicPedestalTileEntity statue, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = statue.m_58904_();
        BlockPos blockPos = statue.m_58899_();
        if (world == null) {
            return;
        }
        BlockState blockState = world.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (!(block instanceof RelicPedestalBlock)) {
            return;
        }
        ModRelics.RelicRecipe relicRecipe = (ModRelics.RelicRecipe)blockState.m_61143_((Property)RelicPedestalBlock.RELIC);
        if (relicRecipe == ModRelics.EMPTY) {
            return;
        }
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.RELIC);
        DynamicModelItem.setGenericModelId(itemStack, relicRecipe.getResultingRelic());
        matrixStack.m_85836_();
        this.renderItem(matrixStack, buffer, combinedLight, combinedOverlay, 1.5f, 1.5f, itemStack);
        matrixStack.m_85849_();
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, int overlay, float yOffset, float scale, ItemStack itemStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, (double)yOffset, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        double rotation = 20.0 * ((double)System.currentTimeMillis() / 1000.0) % 360.0 * (Math.PI / 180);
        matrixStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)rotation), (float)0.0f));
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.GROUND, true, matrixStack, buffer, lightLevel, overlay, bakedModel);
        matrixStack.m_85849_();
    }
}

