/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.BossRunePillarTileEntity;
import iskallia.vault.entity.boss.BossRuneModifiers;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BossRuneItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class RunePillarRenderer
implements BlockEntityRenderer<BossRunePillarTileEntity> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final EntityRenderDispatcher entityRendererDispatcher = Minecraft.m_91087_().m_91290_();

    public RunePillarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull BossRunePillarTileEntity tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        this.renderBoss(tile, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        this.renderLootItems(tile, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        this.renderModifiers(tile, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        this.renderConsumedItem(tile, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    private void renderModifiers(BossRunePillarTileEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        BossRuneModifiers modifiers = tile.getModifiers();
        int i = 0;
        this.renderText(poseStack, buffer, combinedLight, (Component)new TextComponent("Submitted: " + tile.getRuneCount()), 0.0f, 3.0f + (float)i * 0.2f, 0.0f, 0xFFFFFF);
        this.renderText(poseStack, buffer, combinedLight, (Component)new TextComponent("Minimum Runes: " + tile.getRuneMinimum()), 0.0f, 3.0f + (float)(++i) * 0.2f, 0.0f, 0xFFFFFF);
        ++i;
        if (tile.getRuneCount() >= tile.getRuneMinimum()) {
            this.renderText(poseStack, buffer, combinedLight, (Component)new TextComponent("Shift + Right click with an empty hand to summon!").m_130940_(ChatFormatting.GREEN), 0.0f, 3.0f + (float)i * 0.2f, 0.0f, 0xFFFFFF);
        }
        this.renderText(poseStack, buffer, combinedLight, (Component)BossRuneItem.createModifierTooltip(ModifierType.ABILITY_HASTE, modifiers.getAbilityHaste()), 0.0f, 3.0f + (float)(i += 2) * 0.2f, 0.0f, 0xFFFFFF);
        this.renderText(poseStack, buffer, combinedLight, (Component)BossRuneItem.createModifierTooltip(ModifierType.HEALTH, modifiers.getHealthPercent()), 0.0f, 3.0f + (float)(++i) * 0.2f, 0.0f, 0xFFFFFF);
        this.renderText(poseStack, buffer, combinedLight, (Component)BossRuneItem.createModifierTooltip(ModifierType.DAMAGE, modifiers.getDamagePercent()), 0.0f, 3.0f + (float)(++i) * 0.2f, 0.0f, 0xFFFFFF);
        ++i;
        for (Component abilityText : this.getAbilityTexts(modifiers)) {
            this.renderText(poseStack, buffer, combinedLight, abilityText, 0.0f, 3.0f + (float)i * 0.2f, 0.0f, 0xFFFFFF);
            ++i;
        }
        poseStack.m_85849_();
    }

    private void renderText(PoseStack poseStack, MultiBufferSource buffer, int lightLevel, Component text, float x, float y, float z, int color) {
        poseStack.m_85836_();
        float scale = 0.02f;
        Font fontRenderer = RunePillarRenderer.mc.f_91062_;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85845_(mc.m_91290_().m_114470_());
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        fontRenderer.m_92841_(text, offset, 0.0f, -1, false, matrix4f, buffer, true, 0, lightLevel);
        poseStack.m_85849_();
    }

    private void renderLootItems(BossRunePillarTileEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        List<ItemStack> items = tile.getLoot();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        RunePillarRenderer.renderFloatingItems(matrixStack, buffer, combinedLight, combinedOverlay, items.size(), items::get, i -> (double)((float)i / (float)items.size() * 2.0f) * Math.PI + Math.PI * ((double)System.currentTimeMillis() / 3000.0) % (Math.PI * 2));
        matrixStack.m_85849_();
    }

    private void renderRunes(BossRunePillarTileEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int provided = tile.getRuneCount();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        RunePillarRenderer.renderFloatingItems(poseStack, buffer, combinedLight, combinedOverlay, provided, i -> new ItemStack((ItemLike)ModItems.BOSS_RUNE), i -> (double)((float)i / (float)provided * 2.0f) * Math.PI + Math.PI * ((double)System.currentTimeMillis() / 5000.0) % (Math.PI * 2));
        poseStack.m_85849_();
    }

    private static void renderFloatingItems(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, int count, IntFunction<ItemStack> getItem, IntFunction<Double> getAngle) {
        for (int i = 0; i < count; ++i) {
            poseStack.m_85836_();
            ItemStack item = getItem.apply(i);
            if (item.m_41619_()) {
                poseStack.m_85849_();
                continue;
            }
            double angle = getAngle.apply(i);
            double y = Math.sin(angle) * 0.75;
            double x = Math.cos(angle) * 0.75;
            poseStack.m_85837_(x, 0.2 + Math.sin(angle * 2.0) * 0.1, y);
            poseStack.m_85845_(Vector3f.f_122224_.m_122270_((float)(angle + 1.5707963267948966)));
            BakedModel ibakedmodel = mc.m_91291_().m_174264_(item, null, null, 0);
            mc.m_91291_().m_115143_(item, ItemTransforms.TransformType.GROUND, true, poseStack, buffer, combinedLight, combinedOverlay, ibakedmodel);
            poseStack.m_85849_();
        }
    }

    private void renderBoss(BossRunePillarTileEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile.getBoss() == null) {
            return;
        }
        ResourceLocation bossId = tile.getBoss().getId();
        EntityType bossType = (EntityType)ForgeRegistries.ENTITIES.getValue(bossId);
        Entity boss = bossType.m_20615_(tile.m_58904_());
        if (boss == null) {
            return;
        }
        EntityRenderer entityRenderer = this.entityRendererDispatcher.m_114382_(boss);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.PI * ((double)System.currentTimeMillis() / 10000.0) % (Math.PI * 2))));
        poseStack.m_85841_(0.25f, 0.25f, 0.25f);
        entityRenderer.m_7392_(boss, 0.0f, 0.0f, poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }

    private void renderConsumedItem(BossRunePillarTileEntity tile, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile.getHeldItem().m_41619_()) {
            return;
        }
        float lerp = Mth.m_14179_((float)partialTicks, (float)tile.ticksToConsumeOld, (float)tile.ticksToConsume);
        float percentConsumed = 1.0f - lerp / 20.0f;
        ItemStack itemStack = tile.getHeldItem();
        matrixStack.m_85836_();
        this.renderItem(matrixStack, buffer, combinedLight, combinedOverlay, 1.5f - percentConsumed * percentConsumed * percentConsumed, (1.0f - percentConsumed * percentConsumed) * 0.4f + 0.1f, itemStack, tile, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, int overlay, float yOffset, float scale, ItemStack itemStack, BossRunePillarTileEntity scavengerAltarTileEntity, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, (double)yOffset, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        float lerp = Mth.m_14179_((float)partialTicks, (float)scavengerAltarTileEntity.ticksToConsumeOld, (float)scavengerAltarTileEntity.ticksToConsume);
        float ticksToConsumedAnimated = (20.0f - lerp) * (20.0f - lerp);
        double rotation = -10.0 * ((double)System.currentTimeMillis() / 1000.0 + (double)(ticksToConsumedAnimated / 25.0f)) % 360.0 * (Math.PI / 180);
        matrixStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)rotation), (float)0.0f));
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, true, matrixStack, buffer, lightLevel, overlay, bakedModel);
        matrixStack.m_85849_();
    }

    private List<Component> getAbilityTexts(BossRuneModifiers modifiers) {
        ArrayList<Component> abilityTexts = new ArrayList<Component>();
        modifiers.getReviveAbility().ifPresent(settings -> {
            int revives = Math.max(0, settings.reviveCount());
            if (revives > 0) {
                abilityTexts.add(this.createAbilityComponent(revives, "Revive", "Revives"));
            }
        });
        modifiers.getWaveBlastAbility().ifPresent(settings -> abilityTexts.add(this.createAbilityComponent(1, "Wave Blast", "Wave Blast")));
        modifiers.getShieldAbility().ifPresent(settings -> abilityTexts.add(this.createAbilityComponent(1, "Shielded", "Shielded")));
        return abilityTexts;
    }

    private Component createAbilityComponent(int stacks, String singular, String plural) {
        String label = stacks == 1 ? singular : plural;
        MutableComponent component = new TextComponent((String)(stacks > 1 ? "x" + stacks + " " : "+")).m_130940_(ChatFormatting.GRAY);
        component.m_7220_((Component)new TextComponent(label).m_130940_(ChatFormatting.AQUA));
        return component;
    }
}

