/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.block.entity.SurgeBlockTileEntity;
import iskallia.vault.client.gui.helper.Easing;
import iskallia.vault.init.ModBlocks;
import java.util.Random;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SurgeBlockRenderer
implements BlockEntityRenderer<SurgeBlockTileEntity> {
    public SurgeBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SurgeBlockTileEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state = entity.getStoredBlockState();
        if (state == null || state.m_60734_() == ModBlocks.SURGE_BLOCK) {
            return;
        }
        float ratio = SurgeBlockRenderer.ease(entity.getSurgeRatio() * ((float)entity.getLifeTime() + partialTick) / 10.0f);
        SurgeBlockRenderer.renderBlockState(state, ratio, poseStack, buffer, Minecraft.m_91087_().m_91289_(), entity.m_58904_(), entity.m_58899_());
    }

    private static void renderBlockState(BlockState state, float ratio, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                SurgeBlockRenderer.renderBlockState(state, ratio, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockState(BlockState state, float ratio, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderType((RenderType)type);
        SurgeBlockRenderer.tesselateBlock(world, blockRenderer, blockRenderer.m_110910_(state), state, ratio, pos, matrixStack, buffer.m_6299_(type), world.f_46441_);
        ForgeHooksClient.setRenderType(null);
    }

    private static float ease(float value) {
        return Easing.waveCalc(value, Easing.EASE_OUT_SINE, Easing.EASE_OUT_SINE);
    }

    private static void tesselateBlock(Level level, BlockRenderDispatcher blockRenderer, BakedModel model, BlockState state, float ratio, BlockPos pos, PoseStack poseStack, VertexConsumer vertexConsumer, Random random) {
        boolean ambientOcclusion = Minecraft.m_91086_() && state.getLightEmission((BlockGetter)level, pos) == 0 && model.m_7541_();
        Vec3 vec3 = state.m_60824_((BlockGetter)level, pos).m_82520_(0.0, (double)ratio, 0.0);
        poseStack.m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        IModelData modelData = model.getModelData((BlockAndTintGetter)level, pos, state, (IModelData)EmptyModelData.INSTANCE);
        try {
            ModelBlockRenderer modelRenderer = blockRenderer.m_110937_();
            if (ambientOcclusion) {
                modelRenderer.tesselateWithAO((BlockAndTintGetter)level, model, state, pos.m_7494_(), poseStack, vertexConsumer, false, random, 0L, OverlayTexture.f_118083_, modelData);
            } else {
                modelRenderer.tesselateWithoutAO((BlockAndTintGetter)level, model, state, pos.m_7494_(), poseStack, vertexConsumer, false, random, 0L, OverlayTexture.f_118083_, modelData);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block model being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)pos, (BlockState)state);
            crashreportcategory.m_128159_("Using AO", (Object)ambientOcclusion);
            throw new ReportedException(crashreport);
        }
    }
}

