/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.TaskPillarTileEntity;
import iskallia.vault.task.Task;
import iskallia.vault.task.renderer.context.TeamRendererContext;
import iskallia.vault.world.data.TeamTaskData;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class TaskPillarRenderer
implements BlockEntityRenderer<TaskPillarTileEntity> {
    public static final ResourceLocation CHECKMARK = VaultMod.id("textures/gui/bingo/checkmark.png");

    public TaskPillarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TaskPillarTileEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        TeamTaskData teamTaskData = TeamTaskData.get();
        Scoreboard scoreboard = Minecraft.m_91087_().f_91074_.m_36329_();
        RenderSystem.m_69482_();
        Optional<Task> reclaimTask = tileEntity.getReclaimTask((Player)player, teamTaskData, scoreboard);
        reclaimTask.ifPresent(task -> this.renderTaskInfo(tileEntity, partialTicks, poseStack, packedLight, packedOverlay, (Task)task, 1.5, true, teamTaskData, scoreboard));
        if (reclaimTask.isEmpty()) {
            tileEntity.getTask((Player)player, teamTaskData, scoreboard).ifPresent(task -> this.renderTaskInfo(tileEntity, partialTicks, poseStack, packedLight, packedOverlay, (Task)task, 1.5, false, teamTaskData, scoreboard));
        }
    }

    private void renderCompletedBy(TeamRendererContext context, TaskPillarTileEntity tileEntity, TeamTaskData teamTaskData, Scoreboard scoreboard) {
        String taskId = tileEntity.getTaskId();
        if (taskId == null) {
            return;
        }
        teamTaskData.getCompletedTaskTeam(taskId).ifPresent(teamName -> {
            PlayerTeam team = scoreboard.m_83489_(teamName);
            if (team == null) {
                return;
            }
            if (!tileEntity.hasReclaimTaskId()) {
                context.push();
                float scale = 2.0f;
                context.scale(scale, scale, scale);
                context.blit(CHECKMARK, -8, -47, 0, 0, 16, 16, 16, 16);
                context.pop();
            }
            MutableComponent text = new TextComponent("Completed by ").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GOLD)).m_7220_((Component)team.m_83364_().m_6881_().m_130940_(team.m_7414_()));
            Font font = Minecraft.m_91087_().f_91062_;
            int width = font.m_92852_((FormattedText)text);
            float offsetX = (float)(-width) / 2.0f;
            context.push();
            context.translate(0.0, 0.0, 0.02);
            context.fill((int)(offsetX - 3.0f), -57, width + 6, 12, 0x33000000);
            context.pop();
            context.renderText((Component)text, 0.0f, -50.0f, 200, true, true, 0xFFFFFF, false);
        });
    }

    private void renderTaskInfo(TaskPillarTileEntity tileEntity, float partialTicks, PoseStack poseStack, int packedLight, int packedOverlay, Task task, double yOffset, boolean showToClaim, TeamTaskData teamTaskData, Scoreboard scoreboard) {
        poseStack.m_85836_();
        float scale = 0.012f;
        poseStack.m_85837_(0.5, yOffset, 0.5);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        TeamRendererContext context = TeamRendererContext.forWorld(poseStack, partialTicks, Minecraft.m_91087_().f_91062_, packedLight, packedOverlay);
        this.renderCompletedBy(context, tileEntity, teamTaskData, scoreboard);
        if (showToClaim) {
            MutableComponent claimText = new TextComponent("To Claim").m_130940_(ChatFormatting.GREEN);
            int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)claimText);
            int halfWidth = width / 2;
            int y = -35;
            context.fill(-halfWidth - 3, y - 6, width + 6, 10, 0x33000000);
            context.push();
            context.translate(0.0, 0.0, -0.1);
            context.renderText((Component)claimText, 0.0f, y, 200, true, true, 0xFFFFFF, false);
            context.pop();
        }
        task.getRenderer().onRender(task, context);
        poseStack.m_85849_();
    }
}

