/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector4f;
import iskallia.vault.block.TotemMobDamageBlock;
import iskallia.vault.block.entity.TotemMobDamageTileEntity;
import iskallia.vault.block.render.TotemGlowRenderer;
import iskallia.vault.entity.ITotemIgnore;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModRenderTypes;
import iskallia.vault.util.EntityHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TotemMobDamageRenderer
extends TotemGlowRenderer<TotemMobDamageTileEntity> {
    private static final Predicate<Entity> ENTITY_SELECTION_FILTER = entity -> !(entity instanceof Player) && entity instanceof LivingEntity && !(entity instanceof ITotemIgnore);
    private static final float LASER_WIDTH = 0.02f;
    private static final Vector4f LASER_COLOR = new Vector4f(TotemMobDamageTileEntity.PARTICLE_EFFECT_COLOR);

    public TotemMobDamageRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    @Nonnull
    protected BlockState getGlowBlockState() {
        return (BlockState)ModBlocks.TOTEM_MOB_DAMAGE.m_49966_().m_61124_(TotemMobDamageBlock.TYPE, (Comparable)((Object)TotemMobDamageBlock.Type.GLOW));
    }

    @Override
    @ParametersAreNonnullByDefault
    public void render(TotemMobDamageTileEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(ModRenderTypes.TOTEM_LASER_EFFECT);
        TotemMobDamageTileEntity.RenderContext renderContext = (TotemMobDamageTileEntity.RenderContext)blockEntity.getRenderContext();
        AABB effectBounds = blockEntity.getEffectBounds();
        Vec3 effectOrigin = blockEntity.getEffectOrigin();
        float effectRadius = blockEntity.getEffectRadius();
        this.updateTargetList(level, renderContext, effectBounds, effectOrigin, effectRadius);
        for (LivingEntity livingEntity : renderContext.targetList) {
            if (!livingEntity.m_6084_()) continue;
            Vec3 target = livingEntity.m_142469_().m_82399_();
            this.renderLaser(effectOrigin, target, 0.02f, LASER_COLOR, vertexConsumer, poseStack);
            if (level.m_46467_() % 10L != 0L) continue;
            target = livingEntity.m_20299_(partialTick);
            level.m_7106_(blockEntity.getFountainParticleOptions(), target.f_82479_, target.f_82480_, target.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private void updateTargetList(Level level, TotemMobDamageTileEntity.RenderContext renderContext, AABB effectBounds, Vec3 effectOrigin, float effectRadius) {
        boolean updateTargetList = false;
        if (renderContext.targetList == null) {
            renderContext.targetList = new ArrayList<LivingEntity>();
            updateTargetList = true;
        }
        if (level.m_46467_() % 10L == 0L) {
            updateTargetList = true;
        }
        if (updateTargetList) {
            renderContext.targetList.clear();
            EntityHelper.getEntitiesInRange((LevelAccessor)level, effectBounds, effectOrigin, effectRadius, ENTITY_SELECTION_FILTER, renderContext.targetList);
        }
    }

    private void renderLaser(Vec3 origin, Vec3 target, float laserWidth, Vector4f color, VertexConsumer vertexConsumer, PoseStack poseStack) {
        Vec3 vec = target.m_82546_(origin);
        float rotation = 0.0f;
        float pitch = (float)Math.atan2(vec.f_82480_, Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_));
        float yaw = (float)Math.atan2(-vec.f_82481_, vec.f_82479_);
        float length = (float)vec.m_82553_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Quaternion.m_175228_((float)rotation, (float)yaw, (float)pitch));
        this.renderLaser(vertexConsumer, poseStack.m_85850_().m_85861_(), laserWidth, length, color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_());
        poseStack.m_85849_();
    }

    private void renderLaser(VertexConsumer buf, Matrix4f matrix, float laserWidth, float length, float r, float g, float b, float a) {
        for (int i = 0; i < 4; ++i) {
            float width = laserWidth * (float)i * 0.25f;
            buf.m_85982_(matrix, length, width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, -width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, length, -width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, length, -width, -width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, -width, -width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, width, -width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, length, width, -width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, length, width, -width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, width, -width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, length, width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, length, -width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, -width, width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, 0.0f, -width, -width).m_85950_(r, g, b, a).m_5752_();
            buf.m_85982_(matrix, length, -width, -width).m_85950_(r, g, b, a).m_5752_();
        }
    }

    static {
        LASER_COLOR.setW(0.04f);
    }
}

