/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.TotemTileEntity;
import iskallia.vault.init.ModRenderTypes;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public abstract class TotemRenderer<T extends TotemTileEntity>
implements BlockEntityRenderer<T> {
    private static final int GLYPH_COUNT = 16;
    private static final float GLYPH_ALPHA = 0.8f;
    private static final float GLYPH_RING_RADIUS = 1.0f;
    private static final float GLYPH_QUAD_SIZE_X = 0.125f;
    private static final float GLYPH_QUAD_SIZE_Y = 0.125f;
    private static final int GLYPH_TEXTURE_GLYPH_WIDTH = 8;
    private static final int GLYPH_TEXTURE_GLYPH_HEIGHT = 8;
    private static final int GLYPH_TEXTURE_WIDTH = 128;
    private static final int GLYPH_TEXTURE_HEIGHT = 40;
    private static final int GLYPH_TEXTURE_COLUMNS = 16;
    private static final float GLYPH_TEXTURE_GLYPH_U = 0.0625f;
    private static final float GLYPH_TEXTURE_GLYPH_V = 0.2f;
    private static final int GLYPH_INDEX_MIN = 3;
    private static final int GLYPH_INDEX_MAX = 60;
    private static final float[] GLYPH_RING_VERTICES = new float[192];

    public TotemRenderer(BlockEntityRendererProvider.Context context) {
    }

    @ParametersAreNonnullByDefault
    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.TOTEM_GLYPH_EFFECT);
        Object renderContext = ((TotemTileEntity)((Object)blockEntity)).getRenderContext();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (!Minecraft.m_91087_().m_91104_()) {
            ((TotemTileEntity.RenderContext)renderContext).rotationAngleRadians += partialTick * 0.01f;
        }
        poseStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((TotemTileEntity.RenderContext)renderContext).rotationAngleRadians, (float)0.0f));
        if (((TotemTileEntity.RenderContext)renderContext).glyphIndices == null || ((TotemTileEntity.RenderContext)renderContext).glyphIndices.length != 16) {
            ((TotemTileEntity.RenderContext)renderContext).glyphIndices = this.generateGlyphIndices(blockEntity.m_58899_());
        }
        Vector3f glyphColor = ((TotemTileEntity)((Object)blockEntity)).getParticleEffectColor();
        for (int i = 0; i < 16; ++i) {
            float u0 = (float)(((TotemTileEntity.RenderContext)renderContext).glyphIndices[i] % 16) * 0.0625f;
            float v0 = (float)(((TotemTileEntity.RenderContext)renderContext).glyphIndices[i] / 16) * 0.2f;
            float u1 = (float)(((TotemTileEntity.RenderContext)renderContext).glyphIndices[i] % 16 + 1) * 0.0625f;
            float v1 = (float)(((TotemTileEntity.RenderContext)renderContext).glyphIndices[i] / 16 + 1) * 0.2f;
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 0], GLYPH_RING_VERTICES[i * 3 * 4 + 1], GLYPH_RING_VERTICES[i * 3 * 4 + 2]).m_85950_(glyphColor.m_122239_(), glyphColor.m_122260_(), glyphColor.m_122269_(), 0.8f).m_7421_(u0, v0).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 3], GLYPH_RING_VERTICES[i * 3 * 4 + 4], GLYPH_RING_VERTICES[i * 3 * 4 + 5]).m_85950_(glyphColor.m_122239_(), glyphColor.m_122260_(), glyphColor.m_122269_(), 0.8f).m_7421_(u0, v1).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 6], GLYPH_RING_VERTICES[i * 3 * 4 + 7], GLYPH_RING_VERTICES[i * 3 * 4 + 8]).m_85950_(glyphColor.m_122239_(), glyphColor.m_122260_(), glyphColor.m_122269_(), 0.8f).m_7421_(u1, v1).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), GLYPH_RING_VERTICES[i * 3 * 4 + 9], GLYPH_RING_VERTICES[i * 3 * 4 + 10], GLYPH_RING_VERTICES[i * 3 * 4 + 11]).m_85950_(glyphColor.m_122239_(), glyphColor.m_122260_(), glyphColor.m_122269_(), 0.8f).m_7421_(u1, v0).m_85969_(0xF000F0).m_5752_();
        }
        poseStack.m_85849_();
    }

    private int[] generateGlyphIndices(BlockPos blockPos) {
        Random random = new Random(this.trashHash(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
        int[] result = new int[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = Mth.m_144928_((Random)random, (int)3, (int)60);
        }
        return result;
    }

    private long trashHash(int x, int y, int z) {
        long h = (long)x * 374761393L + (long)y * 668265263L + (long)z * 7446411127L;
        h = (h ^ h >> 13) * 1274126177L;
        return h ^ h >> 16;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            double radians = 0.39269908169872414 * (double)i;
            float xCenter = (float)Math.cos(radians) * 1.0f;
            float zCenter = (float)Math.sin(radians) * 1.0f;
            Vec2 center = new Vec2(xCenter, zCenter);
            Vec2 perpendicular = new Vec2(zCenter, -xCenter).m_165902_().m_165903_(0.125f);
            Vec2 c0 = center.m_165910_(perpendicular);
            Vec2 c1 = center.m_165910_(perpendicular.m_165913_());
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 0] = c0.f_82470_;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 1] = 0.125f;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 2] = c0.f_82471_;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 3] = c0.f_82470_;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 4] = -0.125f;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 5] = c0.f_82471_;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 6] = c1.f_82470_;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 7] = -0.125f;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 8] = c1.f_82471_;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 9] = c1.f_82470_;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 10] = 0.125f;
            TotemRenderer.GLYPH_RING_VERTICES[i * 3 * 4 + 11] = c1.f_82471_;
        }
    }
}

