/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import iskallia.vault.block.entity.VaultDiffuserTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VaultDiffuserRenderer
implements BlockEntityRenderer<VaultDiffuserTileEntity> {
    public VaultDiffuserRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VaultDiffuserTileEntity diffuser, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack itemStack;
        Level world = diffuser.m_58904_();
        if (world == null) {
            return;
        }
        float lerp = Mth.m_14179_((float)partialTicks, (float)diffuser.getProgressLastPercent(), (float)diffuser.getProgressPercent());
        if ((double)lerp < 0.4) {
            itemStack = diffuser.getInputInv().m_8020_(0);
            matrixStack.m_85836_();
            this.renderInputItem(matrixStack, buffer, combinedLight, combinedOverlay, 0.6f, 0.35f - lerp / 2.0f, itemStack, diffuser, partialTicks);
            matrixStack.m_85849_();
        }
        itemStack = diffuser.getOutputInv().m_8020_(0);
        matrixStack.m_85836_();
        this.renderOutputItem(matrixStack, buffer, combinedLight, combinedOverlay, 1.4f, 0.35f, itemStack, diffuser, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderInputItem(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, int overlay, float yOffset, float scale, ItemStack itemStack, VaultDiffuserTileEntity diffuser, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, (double)yOffset, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        float lerp = Mth.m_14179_((float)partialTicks, (float)diffuser.getProgressLastPercent(), (float)diffuser.getProgressPercent());
        float ticksToConsumedAnimated = lerp * lerp * lerp;
        double rotation = -10.0 * ((double)System.currentTimeMillis() / 400.0 + (double)(180.0f * ticksToConsumedAnimated)) % 360.0 * (Math.PI / 180);
        matrixStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)rotation), (float)0.0f));
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, true, matrixStack, buffer, lightLevel, overlay, bakedModel);
        matrixStack.m_85849_();
    }

    private void renderOutputItem(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, int overlay, float yOffset, float scale, ItemStack itemStack, VaultDiffuserTileEntity diffuser, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, (double)yOffset, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        double rotation = -10.0 * ((double)System.currentTimeMillis() / 200.0) % 360.0 * (Math.PI / 180);
        matrixStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)rotation), (float)0.0f));
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, true, matrixStack, buffer, lightLevel, overlay, bakedModel);
        matrixStack.m_85849_();
    }
}

