/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.block.WardrobeBlock;
import iskallia.vault.block.entity.WardrobeTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;
import top.theillusivec4.curios.client.render.CuriosLayer;

public class WardrobeRenderer
implements BlockEntityRenderer<WardrobeTileEntity>,
RenderLayerParent<Player, PlayerModel<Player>> {
    private final PlayerModel<Player> steveModel;
    private final List<RenderLayer<Player, PlayerModel<Player>>> layers = Lists.newArrayList();

    public WardrobeRenderer(BlockEntityRendererProvider.Context context) {
        this.steveModel = new PlayerModel(context.m_173582_(ModelLayers.f_171162_), false);
        this.steveModel.f_102610_ = false;
        this.addLayer((RenderLayer<Player, PlayerModel<Player>>)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_173582_(ModelLayers.f_171164_)), new HumanoidModel(context.m_173582_(ModelLayers.f_171165_))));
        this.addLayer((RenderLayer<Player, PlayerModel<Player>>)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer<Player, PlayerModel<Player>>)new ElytraLayer((RenderLayerParent)this, context.m_173585_()));
        this.addLayer((RenderLayer<Player, PlayerModel<Player>>)new CustomHeadLayer((RenderLayerParent)this, context.m_173585_()));
        this.addLayer((RenderLayer<Player, PlayerModel<Player>>)new CuriosLayer((RenderLayerParent)this));
    }

    private void addLayer(RenderLayer<Player, PlayerModel<Player>> layer) {
        this.layers.add(layer);
    }

    public void render(WardrobeTileEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float floatingYDiff = Mth.m_14031_((float)((float)blockEntity.m_58899_().hashCode() + ((float)(System.currentTimeMillis() / 80L % 1000L) + partialTick) / 10.0f)) * 0.4f;
        this.steveModel.f_102810_.f_104201_ += floatingYDiff;
        this.steveModel.f_102812_.f_104201_ += floatingYDiff;
        this.steveModel.f_102811_.f_104201_ += floatingYDiff;
        this.steveModel.f_102808_.f_104201_ += floatingYDiff;
        this.steveModel.f_102814_.f_104201_ += floatingYDiff;
        this.steveModel.f_102813_.f_104201_ += floatingYDiff;
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        MultiBufferSource transparentBufferSource = WardrobeRenderer.getBufferSourceForSetTransparency(blockEntity, bufferSource);
        this.renderLayers(blockEntity, partialTick, poseStack, packedLight, transparentBufferSource);
        WardrobeRenderer.renderCurios(blockEntity, partialTick, poseStack, packedLight, transparentBufferSource);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        this.steveModel.f_102808_.f_104201_ = 0.0f;
        this.steveModel.f_102810_.f_104201_ = 0.0f;
        this.steveModel.f_102812_.f_104201_ = 2.0f;
        this.steveModel.f_102811_.f_104201_ = 2.0f;
        this.steveModel.f_102814_.f_104201_ = 12.0f;
        this.steveModel.f_102813_.f_104201_ = 12.0f;
    }

    private static MultiBufferSource getBufferSourceForSetTransparency(WardrobeTileEntity blockEntity, MultiBufferSource bufferSource) {
        return blockEntity.shouldRenderSolid() ? bufferSource : new TransparentMultiBufferSource(bufferSource, WardrobeRenderer.getTransparency(blockEntity));
    }

    private static void renderCurios(WardrobeTileEntity blockEntity, float partialTick, PoseStack poseStack, int packedLight, MultiBufferSource transparentBufferSource) {
        ArrayList stacksToRender = new ArrayList();
        blockEntity.getCuriosItems().forEach((slotKey, stacks) -> stacks.forEach((slot, stack) -> {
            if (!stack.m_41619_()) {
                stacksToRender.add(stack);
            }
        }));
        if (!stacksToRender.isEmpty()) {
            poseStack.m_85837_(0.5, 0.4, 0.5);
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(((Direction)blockEntity.m_58900_().m_61143_((Property)WardrobeBlock.FACING)).m_122424_().m_122435_()));
            poseStack.m_85841_(0.4f, 0.4f, 0.4f);
            AtomicInteger itemIndex = new AtomicInteger(0);
            float sideDistance = stacksToRender.size() == 1 ? 0.0f : 2.0f / (float)(stacksToRender.size() / 2 + 1);
            boolean isOdd = stacksToRender.size() % 2 == 1;
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            stacksToRender.forEach(stack -> {
                poseStack.m_85836_();
                int index = itemIndex.get();
                float floatingY = Mth.m_14031_((float)((float)index + ((float)(System.currentTimeMillis() / 100L % 1000L) + partialTick) / 10.0f)) * 0.03f;
                if (isOdd && index == 0) {
                    poseStack.m_85837_(0.0, (double)floatingY, -1.0);
                } else {
                    if (isOdd) {
                        --index;
                    }
                    poseStack.m_85837_((double)(-1.0f + (float)(index % 2 * 2)), (double)floatingY, (double)(-1.0f + sideDistance * (float)(index / 2 + 1)));
                }
                itemRenderer.m_174269_(stack, ItemTransforms.TransformType.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, transparentBufferSource, 0);
                poseStack.m_85849_();
                itemIndex.incrementAndGet();
            });
        }
    }

    private void renderLayers(WardrobeTileEntity blockEntity, float partialTick, PoseStack poseStack, int packedLight, MultiBufferSource transparentBufferSource) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 2.05, 0.5);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((Direction)blockEntity.m_58900_().m_61143_((Property)WardrobeBlock.FACING)).m_122435_()));
        this.layers.forEach(layer -> layer.m_6494_(poseStack, transparentBufferSource, packedLight, (Entity)blockEntity.getDummyRenderPlayer(), 0.0f, 0.0f, partialTick, 0.0f, 0.0f, 0.0f));
        poseStack.m_85849_();
    }

    private static int getTransparency(WardrobeTileEntity blockEntity) {
        Random rand = blockEntity.m_58904_().f_46441_;
        int regularTransparency = 140;
        if (System.currentTimeMillis() % (long)Math.abs(blockEntity.m_58899_().hashCode()) < 300L) {
            int error = 20;
            return rand.nextInt(error) + regularTransparency - error / 2;
        }
        return regularTransparency;
    }

    public PlayerModel<Player> getModel() {
        return this.steveModel;
    }

    public ResourceLocation getTextureLocation(Player pEntity) {
        return null;
    }

    private static class TransparentMultiBufferSource
    implements MultiBufferSource {
        private final MultiBufferSource bufferSource;
        private final int alpha;

        public TransparentMultiBufferSource(MultiBufferSource bufferSource, int alpha) {
            this.bufferSource = bufferSource;
            this.alpha = alpha;
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            if (renderType == RenderType.m_110484_() || renderType == RenderType.m_110481_()) {
                return new TransparentVertexConsumer(this.bufferSource.m_6299_(RenderType.m_110499_()), this.alpha);
            }
            if (renderType == RenderType.m_110487_() || renderType == RenderType.m_110490_() || renderType == RenderType.m_110493_()) {
                return new TransparentVertexConsumer(this.bufferSource.m_6299_(renderType), this.alpha);
            }
            if (renderType instanceof RenderType.CompositeRenderType) {
                RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
                RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = compositeRenderType.m_173265_().f_110576_;
                if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
                    RenderStateShard.TextureStateShard textureStateShard = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
                    return new TransparentVertexConsumer(this.bufferSource.m_6299_(textureStateShard.m_142706_().map(RenderType::m_110473_).orElseGet(() -> renderType)), this.alpha);
                }
            }
            return new TransparentVertexConsumer(this.bufferSource.m_6299_(renderType), this.alpha);
        }
    }

    private static class TransparentVertexConsumer
    extends DefaultedVertexConsumer {
        private final VertexConsumer delegate;

        public TransparentVertexConsumer(VertexConsumer delegate, int alpha) {
            this.delegate = delegate;
            this.f_85828_ = alpha;
        }

        public void m_5954_(float pX, float pY, float pZ, float pRed, float pGreen, float pBlue, float pAlpha, float pTexU, float pTexV, int pOverlayUV, int pLightmapUV, float pNormalX, float pNormalY, float pNormalZ) {
            super.m_5954_(pX, pY, pZ, pRed, pGreen, pBlue, (float)this.f_85828_ / 256.0f, pTexU, pTexV, pOverlayUV, pLightmapUV, pNormalX, pNormalY, pNormalZ);
        }

        public VertexConsumer m_5483_(double pX, double pY, double pZ) {
            return this.delegate.m_5483_(pX, pY, pZ);
        }

        public VertexConsumer m_6122_(int pRed, int pGreen, int pBlue, int pAlpha) {
            return this.delegate.m_6122_(pRed, pGreen, pBlue, this.f_85828_);
        }

        public VertexConsumer m_7421_(float pU, float pV) {
            return this.delegate.m_7421_(pU, pV);
        }

        public VertexConsumer m_7122_(int pU, int pV) {
            return this.delegate.m_7122_(pU, pV);
        }

        public VertexConsumer m_7120_(int pU, int pV) {
            return this.delegate.m_7120_(pU, pV);
        }

        public VertexConsumer m_5601_(float pX, float pY, float pZ) {
            return this.delegate.m_5601_(pX, pY, pZ);
        }

        public void m_5752_() {
            this.delegate.m_5752_();
        }
    }
}

