/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty;

import iskallia.vault.bounty.Bounty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class BountyList
extends ArrayList<Bounty>
implements INBTSerializable<CompoundTag> {
    public BountyList() {
    }

    public BountyList(List<Bounty> list) {
        this.addAll(list);
    }

    public BountyList(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public Optional<Bounty> findById(UUID id) {
        return this.stream().filter(bounty -> bounty.getId().equals(id)).findFirst();
    }

    public boolean removeById(UUID id) {
        return this.removeIf(bounty -> bounty.getId().equals(id));
    }

    public boolean contains(UUID id) {
        return this.stream().anyMatch(bounty -> bounty.getId().equals(id));
    }

    public CompoundTag serializeNBT() {
        CompoundTag bountyListTag = new CompoundTag();
        this.forEach((? super E bounty) -> bountyListTag.m_128365_(bounty.getId().toString(), (Tag)bounty.serializeNBT()));
        return bountyListTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        nbt.m_128431_().forEach((? super T key) -> this.add(new Bounty(nbt.m_128469_(key))));
    }
}

