/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.client;

import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.client.ClientExpertiseData;
import iskallia.vault.init.ModItems;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.expertise.type.BountyHunterExpertise;
import iskallia.vault.util.InventoryUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientBountyData {
    public static final ClientBountyData INSTANCE = new ClientBountyData();
    private final BountyList bounties = new BountyList();
    private final BountyList available = new BountyList();
    private static int maxActiveBounties = 1;
    private static boolean searchForLostBounty = false;
    private static boolean hasLostBountyInInventory = false;
    private static boolean hasCompletedBounty = false;
    private static boolean hasLegendaryBounty = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        maxActiveBounties = 1;
        for (TieredSkill learnedTalentNode : ClientExpertiseData.getLearnedTalentNodes()) {
            LearnableSkill learnableSkill = learnedTalentNode.getChild();
            if (!(learnableSkill instanceof BountyHunterExpertise)) continue;
            BountyHunterExpertise bountyHunterExpertise = (BountyHunterExpertise)learnableSkill;
            maxActiveBounties = bountyHunterExpertise.getMaxActive();
        }
        if (searchForLostBounty) {
            hasLostBountyInInventory = InventoryUtil.hasItem((Player)player, ModItems.LOST_BOUNTY);
            searchForLostBounty = false;
        }
        BountyList bounties = INSTANCE.getBounties();
        hasCompletedBounty = false;
        hasLegendaryBounty = false;
        for (Bounty bounty : bounties) {
            if (bounty.getTask().isComplete()) {
                hasCompletedBounty = true;
            }
            if (!((TaskProperties)bounty.getTask().getProperties()).getRewardPool().equals("legendary")) continue;
            hasLegendaryBounty = true;
        }
    }

    @SubscribeEvent
    public static void onLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ClientBountyData.INSTANCE.bounties.clear();
        ClientBountyData.INSTANCE.available.clear();
    }

    public void updateBounties(BountyList bounties) {
        this.bounties.clear();
        this.bounties.addAll(bounties);
    }

    public void updateAvailableBounties(BountyList bounties) {
        this.available.clear();
        this.available.addAll(bounties);
    }

    public void requestLostBountySearch() {
        searchForLostBounty = true;
    }

    public BountyList getBounties() {
        return this.bounties;
    }

    public BountyList getAvailable() {
        return this.available;
    }

    public static int getMaxActiveBounties() {
        return maxActiveBounties;
    }

    public static boolean hasLostBountyInInventory() {
        return hasLostBountyInInventory;
    }

    public static boolean hasCompletedBounty() {
        return hasCompletedBounty;
    }

    public static boolean hasLegendaryBounty() {
        return hasLegendaryBounty;
    }
}

