/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.VaultMod;
import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.ItemDiscoveryProperties;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.event.common.CoinStacksGenerationEvent;
import iskallia.vault.core.event.common.LootableBlockGenerationEvent;
import iskallia.vault.world.data.BountyData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemDiscoveryTask
extends Task<ItemDiscoveryProperties> {
    private static final HashMap<UUID, List<ItemStack>> cachedItems = new HashMap();

    public ItemDiscoveryTask(UUID bountyId, ItemDiscoveryProperties properties, TaskReward taskReward) {
        super(TaskRegistry.ITEM_DISCOVERY, bountyId, properties, taskReward);
    }

    public ItemDiscoveryTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        if (!cachedItems.containsKey(player.m_142081_()) || cachedItems.get(player.m_142081_()).isEmpty()) {
            return false;
        }
        List<ItemStack> stacks = cachedItems.get(player.m_142081_());
        for (ItemStack stack : stacks) {
            Item item = stack.m_41720_();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
            ResourceLocation requiredItem = ((ItemDiscoveryProperties)this.getProperties()).getItemId();
            if (itemId == null || !itemId.equals((Object)requiredItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((ItemDiscoveryProperties)this.getProperties()).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((ItemDiscoveryProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new ItemDiscoveryProperties(tag.m_128469_("properties"));
    }

    public static <T> void onLootGeneration(T event) {
        List<ItemStack> items;
        ServerPlayer player;
        if (event instanceof ChestGenerationEvent.Data) {
            ChestGenerationEvent.Data e = (ChestGenerationEvent.Data)event;
            player = e.getPlayer();
            items = e.getLoot();
        } else if (event instanceof LivingDropsEvent) {
            LivingDropsEvent e = (LivingDropsEvent)event;
            if (!(e.getSource().m_7639_() instanceof ServerPlayer)) {
                return;
            }
            player = (ServerPlayer)e.getSource().m_7639_();
            items = e.getDrops().stream().map(ItemEntity::m_32055_).toList();
        } else if (event instanceof CoinStacksGenerationEvent.Data) {
            CoinStacksGenerationEvent.Data e = (CoinStacksGenerationEvent.Data)event;
            player = e.getPlayer();
            items = e.getLoot();
        } else if (event instanceof LootableBlockGenerationEvent.Data) {
            LootableBlockGenerationEvent.Data e = (LootableBlockGenerationEvent.Data)event;
            if (e.getPlayer() == null) {
                return;
            }
            player = e.getPlayer();
            items = e.getLoot();
        } else {
            VaultMod.LOGGER.warn("Attempted to validate an unregistered event.");
            return;
        }
        cachedItems.put(player.m_142081_(), new ArrayList<ItemStack>(items));
        boolean legendaryComplete = false;
        BountyData data = BountyData.get();
        List legendary = data.getAllLegendaryById(player, TaskRegistry.ITEM_DISCOVERY);
        block0: for (ItemDiscoveryTask task : legendary) {
            if (task.isComplete()) continue;
            List<ItemStack> cached = cachedItems.get(player.m_142081_());
            if (!task.validate(player, event)) continue;
            for (ItemStack stack : items) {
                if (legendaryComplete) continue block0;
                Item item = stack.m_41720_();
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
                ResourceLocation requiredItem = ((ItemDiscoveryProperties)task.getProperties()).getItemId();
                if (itemId == null || !itemId.equals((Object)requiredItem)) continue;
                task.increment(stack.m_41613_());
                cached.remove(stack);
                if (!task.isComplete()) continue;
                legendaryComplete = true;
                task.complete(player);
            }
        }
        List activeTasks = data.getAllActiveById(player, TaskRegistry.ITEM_DISCOVERY);
        block2: for (ItemDiscoveryTask task : activeTasks) {
            if (task.isComplete() || !task.validate(player, event)) continue;
            List<ItemStack> cached = cachedItems.get(player.m_142081_());
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(cached);
            for (ItemStack stack : stacks) {
                Item item = stack.m_41720_();
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
                ResourceLocation requiredItem = ((ItemDiscoveryProperties)task.getProperties()).getItemId();
                if (itemId == null || !itemId.equals((Object)requiredItem)) continue;
                task.increment(stack.m_41613_());
                cached.remove(stack);
                if (!task.isComplete()) continue;
                task.complete(player);
                continue block2;
            }
        }
        cachedItems.remove(player.m_142081_());
    }
}

