/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client;

import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.network.message.AbilityActivityMessage;
import iskallia.vault.network.message.AbilityFocusMessage;
import iskallia.vault.network.message.AbilityKnownOnesMessage;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;

public class ClientAbilityData {
    private static AbilityTree ABILITIES = new AbilityTree();

    public static AbilityTree getTree() {
        return ABILITIES;
    }

    public static boolean isSelectedAbility(SpecializedSkill ability) {
        SpecializedSkill selected = ABILITIES.getSelected();
        return selected != null && selected.getId().equals(ability.getId());
    }

    @Nonnull
    public static List<TieredSkill> getLearnedAbilities() {
        ArrayList<TieredSkill> abilities = new ArrayList<TieredSkill>();
        ABILITIES.iterate(TieredSkill.class, ability -> {
            if (ability.isUnlocked() && ((SpecializedSkill)ability.getParent()).getSpecialization() == ability) {
                abilities.add((TieredSkill)ability);
            }
        });
        return abilities;
    }

    @Nullable
    public static SpecializedSkill getSelected() {
        return ABILITIES.getSelected();
    }

    @Nullable
    public static Ability getSelectedAbility() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        return Optional.ofNullable(ClientAbilityData.getSelected()).map(SpecializedSkill::getSpecialization).filter(skill -> skill instanceof TieredSkill).map(skill -> ((TieredSkill)skill).getChild()).filter(skill -> skill instanceof Ability).orElse(null);
    }

    public static Skill getParent(Ability ability) {
        ArrayList candidates = new ArrayList();
        ABILITIES.iterate(SpecializedSkill.class, skill -> {
            if (ability.getId().equals(skill.getSpecialization().getId())) {
                candidates.add(skill);
            }
        });
        return candidates.isEmpty() ? null : (Skill)candidates.get(0);
    }

    public static int getIndexOf(String ability) {
        List<TieredSkill> nodes = ClientAbilityData.getLearnedAbilities();
        for (int i = 0; i < nodes.size(); ++i) {
            TieredSkill node = nodes.get(i);
            if (!node.getId().equals(ability)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static TieredSkill getLearnedAbilityNode(String abilityName) {
        for (TieredSkill node : ClientAbilityData.getLearnedAbilities()) {
            if (!node.getId().equals(abilityName)) continue;
            return node;
        }
        return null;
    }

    public static void updateAbilities(AbilityKnownOnesMessage pkt) {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        pkt.getTree().writeBits(buffer);
        buffer.setPosition(0);
        ABILITIES.readBits(buffer);
    }

    public static void updateSelectedAbility(AbilityFocusMessage pkt) {
    }

    public static void updateActivity(AbilityActivityMessage pkt) {
    }
}

