/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client;

import iskallia.vault.network.message.transmog.DiscoveredEntriesMessage;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ClientDiscoveredEntriesData {
    public static void receiveMessage(DiscoveredEntriesMessage message) {
        switch (message.type()) {
            case MODELS: {
                Models.receiveMessage(message.discoveredEntries());
                break;
            }
            case TRINKETS: {
                Trinkets.receiveMessage(message.discoveredEntries());
                break;
            }
            case ARTIFACTS: {
                Artifacts.receiveMessage(message.discoveredEntries());
                break;
            }
            case COMPANION_VARIANTS: {
                CompanionVariants.receiveMessage(message.discoveredEntries());
            }
        }
    }

    public static class Models {
        private static final Set<ResourceLocation> discoveredModels = new HashSet<ResourceLocation>();

        public static Set<ResourceLocation> getDiscoveredModels() {
            return new HashSet<ResourceLocation>(discoveredModels);
        }

        public static ObservableSupplier<Set<ResourceLocation>> getObserverModels() {
            return ObservableSupplier.of(Models::getDiscoveredModels, (modelSet, newModelSet) -> modelSet.size() == newModelSet.size());
        }

        private static void receiveMessage(Set<ResourceLocation> models) {
            discoveredModels.clear();
            discoveredModels.addAll(models);
        }
    }

    public static class Trinkets {
        private static final Set<ResourceLocation> discoveredTrinkets = new HashSet<ResourceLocation>();

        public static Set<ResourceLocation> getDiscoveredTrinkets() {
            return new HashSet<ResourceLocation>(discoveredTrinkets);
        }

        public static ObservableSupplier<Set<ResourceLocation>> getObserverTrinkets() {
            return ObservableSupplier.of(Trinkets::getDiscoveredTrinkets, (modelSet, newModelSet) -> modelSet.size() == newModelSet.size());
        }

        private static void receiveMessage(Set<ResourceLocation> trinkets) {
            discoveredTrinkets.clear();
            discoveredTrinkets.addAll(trinkets);
        }
    }

    public static class Artifacts {
        private static final Set<ResourceLocation> discoveredArtifacts = new HashSet<ResourceLocation>();

        public static Set<ResourceLocation> getDiscoveredArtifacts() {
            return new HashSet<ResourceLocation>(discoveredArtifacts);
        }

        public static ObservableSupplier<Set<ResourceLocation>> getObserverArtifacts() {
            return ObservableSupplier.of(Artifacts::getDiscoveredArtifacts, (artifactSet, newArtifactSet) -> artifactSet.size() == newArtifactSet.size());
        }

        private static void receiveMessage(Set<ResourceLocation> artifacts) {
            discoveredArtifacts.clear();
            discoveredArtifacts.addAll(artifacts);
        }
    }

    public static class CompanionVariants {
        private static final Set<String> unlockedVariants = new HashSet<String>();

        public static Set<String> getUnlockedVariants() {
            return new HashSet<String>(unlockedVariants);
        }

        public static boolean isUnlocked(String variantId) {
            return unlockedVariants.contains(variantId.toLowerCase(Locale.ROOT));
        }

        private static void receiveMessage(Set<ResourceLocation> variants) {
            unlockedVariants.clear();
            variants.stream().map(ResourceLocation::m_135815_).map(path -> path.toLowerCase(Locale.ROOT)).forEach(unlockedVariants::add);
        }
    }

    public static class AlchemyEffects {
        private static Set<String> discoveredAlchemyEffects = new HashSet<String>();

        public static Set<String> getDiscoveredAlchemyEffects() {
            return discoveredAlchemyEffects;
        }

        public static void receiveMessage(Set<String> effects) {
            discoveredAlchemyEffects = effects;
        }
    }

    public static class WorkbenchCrafts {
        private static Map<Item, Set<ResourceLocation>> discoveredWorkbenchCrafts = new HashMap<Item, Set<ResourceLocation>>();

        public static Set<ResourceLocation> getDiscoveredWorkbenchCrafts(Item gearItem) {
            return new HashSet<ResourceLocation>(discoveredWorkbenchCrafts.getOrDefault(gearItem, Collections.emptySet()));
        }

        public static ObservableSupplier<Set<ResourceLocation>> getObserverWorkbenchCrafts(Item gearItem) {
            return ObservableSupplier.of(() -> WorkbenchCrafts.getDiscoveredWorkbenchCrafts(gearItem), (crafts, newCrafts) -> crafts.size() == newCrafts.size());
        }

        public static void receiveMessage(Map<Item, Set<ResourceLocation>> workbenchCrafts) {
            discoveredWorkbenchCrafts = workbenchCrafts;
        }
    }
}

