/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client;

import iskallia.vault.world.data.VaultPartyData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;

public class ClientPartyData {
    private static final List<VaultPartyData.Party> parties = new ArrayList<VaultPartyData.Party>();
    private static final Map<UUID, PartyMember> cachedPartyMembers = new HashMap<UUID, PartyMember>();

    public static void clearClientCache() {
        parties.clear();
        cachedPartyMembers.clear();
    }

    @Nullable
    public static VaultPartyData.Party getParty(UUID playerUUID) {
        for (VaultPartyData.Party party : parties) {
            if (!party.hasMember(playerUUID)) continue;
            return party;
        }
        return null;
    }

    @Nullable
    public static PartyMember getCachedMember(@Nullable UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        return cachedPartyMembers.get(playerUUID);
    }

    public static void receivePartyUpdate(ListTag partyData) {
        parties.clear();
        for (int i = 0; i < partyData.size(); ++i) {
            CompoundTag data = partyData.m_128728_(i);
            VaultPartyData.Party party = new VaultPartyData.Party();
            party.deserializeNBT(data);
            parties.add(party);
        }
    }

    public static void receivePartyMembers(ListTag partyMembers) {
        for (int i = 0; i < partyMembers.size(); ++i) {
            CompoundTag nbt = partyMembers.m_128728_(i);
            PartyMember partyMember = new PartyMember();
            partyMember.deserializeNBT(nbt);
            cachedPartyMembers.put(partyMember.playerUUID, partyMember);
        }
    }

    public static class PartyMember
    implements INBTSerializable<CompoundTag> {
        public UUID playerUUID;
        public float healthPts;
        public Status status = Status.NORMAL;
        public double posX;
        public double posY;
        public double posZ;

        public PartyMember() {
        }

        public PartyMember(Player player) {
            this.playerUUID = player.m_142081_();
            this.healthPts = player.m_21223_();
            this.posX = player.m_20185_();
            this.posY = player.m_20186_();
            this.posZ = player.m_20189_();
            if (this.healthPts <= 0.0f) {
                this.status = Status.DEAD;
            } else {
                for (MobEffectInstance potionEffect : player.m_21220_()) {
                    MobEffect potion = potionEffect.m_19544_();
                    if (potion == MobEffects.f_19614_) {
                        this.status = Status.POISONED;
                        break;
                    }
                    if (potion != MobEffects.f_19615_) continue;
                    this.status = Status.WITHERED;
                    break;
                }
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_("PlayerUUID", this.playerUUID);
            nbt.m_128350_("HealthPts", this.healthPts);
            nbt.m_128405_("StatusIndex", this.status.ordinal());
            nbt.m_128347_("PosX", this.posX);
            nbt.m_128347_("PosY", this.posY);
            nbt.m_128347_("PosZ", this.posZ);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerUUID = nbt.m_128342_("PlayerUUID");
            this.healthPts = nbt.m_128457_("HealthPts");
            this.status = Status.values()[nbt.m_128451_("StatusIndex")];
            if (nbt.m_128441_("PosX")) {
                this.posX = nbt.m_128459_("PosX");
            }
            if (nbt.m_128441_("PosY")) {
                this.posY = nbt.m_128459_("PosY");
            }
            if (nbt.m_128441_("PosZ")) {
                this.posZ = nbt.m_128459_("PosZ");
            }
        }

        public static enum Status {
            NORMAL,
            POISONED,
            WITHERED,
            DEAD;

        }
    }
}

