/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client;

import iskallia.vault.client.gui.screen.PrestigePowerSelectionScreen;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.network.message.KnownPrestigePowersMessage;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import iskallia.vault.skill.tree.PrestigeTree;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class ClientPrestigePowersData {
    private static PrestigeTree PRESTIGE = new PrestigeTree();

    public static PrestigeTree getTree() {
        return PRESTIGE;
    }

    @Nonnull
    public static List<TieredSkill> getLearnedPrestigeNodes() {
        ArrayList<TieredSkill> prestigeList = new ArrayList<TieredSkill>();
        PRESTIGE.iterate(TieredSkill.class, prestige -> {
            if (prestige.isUnlocked()) {
                prestigeList.add((TieredSkill)prestige);
            }
        });
        return prestigeList;
    }

    @Nonnull
    public static List<TieredSkill> getLearnedActivatablePrestigeNodes() {
        ArrayList<TieredSkill> prestigeList = new ArrayList<TieredSkill>();
        PRESTIGE.iterate(TieredSkill.class, prestige -> {
            if (prestige.isUnlocked() && prestige.getChild() instanceof ActivatePrestigePower) {
                prestigeList.add((TieredSkill)prestige);
            }
        });
        return prestigeList;
    }

    @Nullable
    public static TieredSkill getLearnedPrestigeNode(String prestigePowerName) {
        for (TieredSkill node : ClientPrestigePowersData.getLearnedPrestigeNodes()) {
            if (!node.getId().equals(prestigePowerName)) continue;
            return node;
        }
        return null;
    }

    public static void updatePrestigePowers(KnownPrestigePowersMessage pkt) {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        pkt.tree().writeBits(buffer);
        buffer.setPosition(0);
        PRESTIGE.readBits(buffer);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof PrestigePowerSelectionScreen) {
            PrestigePowerSelectionScreen selectionScreen = (PrestigePowerSelectionScreen)screen;
            Minecraft.m_91087_().f_91080_.m_6575_(Minecraft.m_91087_(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        }
    }
}

