/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.screen.player.AbilitiesElementContainerScreen;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.skill.base.SpecializedSkill;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VaultAbilityKeyBinding {
    public static boolean isEnabled = false;
    private static final long STATE_TIMEOUT_MS = 50L;
    private static final int LEFT_MOUSE_BUTTON = 0;
    private static final int RIGHT_MOUSE_BUTTON = 1;
    private static long lastRefresh = 0L;
    public static boolean abilityHovering = false;
    private static boolean keyPressed = false;
    private static boolean mousePressed = false;
    public static SpecializedSkill skill = null;
    public static KeyMapping keyMapping = null;

    public static void refresh() {
        lastRefresh = System.currentTimeMillis();
    }

    private static boolean isStateExpired() {
        return System.currentTimeMillis() - lastRefresh > 50L;
    }

    @SubscribeEvent
    public static void onScreenDraw(ScreenEvent.DrawScreenEvent event) {
        if (!(Minecraft.m_91087_().f_91080_ instanceof AbilitiesElementContainerScreen)) {
            return;
        }
        if (abilityHovering && skill != null && keyMapping != null && VaultAbilityKeyBinding.isStateExpired()) {
            VaultAbilityKeyBinding.resetBindingState();
        }
    }

    @SubscribeEvent
    public static void onKeyInput(ScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (!VaultAbilityKeyBinding.isValidBindingState() || keyPressed) {
            return;
        }
        keyPressed = true;
        if (event.getKeyCode() == 256) {
            VaultAbilityKeyBinding.setKeyMapping(KeyModifier.NONE, InputConstants.f_84822_);
        } else {
            KeyModifier modifier = KeyModifier.getActiveModifier();
            VaultAbilityKeyBinding.setKeyMapping(modifier, InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode()));
        }
        VaultAbilityKeyBinding.resetBindingState();
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onMouseInput(ScreenEvent.MouseClickedEvent.Pre event) {
        if (!VaultAbilityKeyBinding.isValidBindingState() || mousePressed) {
            return;
        }
        mousePressed = true;
        if (event.getButton() == 0 || event.getButton() == 1) {
            return;
        }
        VaultAbilityKeyBinding.setKeyMapping(KeyModifier.NONE, InputConstants.Type.MOUSE.m_84895_(event.getButton()));
        VaultAbilityKeyBinding.resetBindingState();
        event.setCanceled(true);
    }

    private static boolean isValidBindingState() {
        return abilityHovering && skill != null && keyMapping != null && isEnabled && Minecraft.m_91087_().f_91080_ instanceof AbilitiesElementContainerScreen;
    }

    private static void setKeyMapping(KeyModifier modifier, InputConstants.Key key) {
        if (!key.equals((Object)InputConstants.f_84822_)) {
            for (Map.Entry<String, KeyMapping> entry : ModKeybinds.abilityQuickfireKey.entrySet()) {
                KeyMapping other = entry.getValue();
                if (other == keyMapping || !other.getKey().equals((Object)key) || other.getKeyModifier() != modifier) continue;
                other.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.f_84822_);
                VaultMod.LOGGER.info("Removed keybinding {} from ability {} due to reassignment", (Object)key, (Object)entry.getKey());
            }
        }
        keyMapping.setKeyModifierAndCode(modifier, key);
        KeyMapping.m_90854_();
        Minecraft.m_91087_().f_91066_.m_92169_();
    }

    private static void resetBindingState() {
        keyMapping = null;
        skill = null;
        abilityHovering = false;
    }

    @SubscribeEvent
    public static void onKeyRelease(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 0) {
            keyPressed = false;
        }
    }

    @SubscribeEvent
    public static void onMouseRelease(InputEvent.MouseInputEvent event) {
        if (event.getAction() == 0) {
            mousePressed = false;
        }
    }
}

