/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class VaultSoundOptions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final VaultSoundOptions INSTANCE = new VaultSoundOptions();
    private static final String CONFIG_FILENAME = "vault_soundOptions.txt";
    private final Map<ResourceLocation, Float> soundVolumes = Maps.newConcurrentMap();
    private boolean isDirty = false;

    private VaultSoundOptions() {
    }

    public static VaultSoundOptions getInstance() {
        return INSTANCE;
    }

    public float getVolume(SoundEvent soundEvent) {
        if (soundEvent == null) {
            return 1.0f;
        }
        return this.getVolume(soundEvent.m_11660_());
    }

    public float getVolume(ResourceLocation soundId) {
        return this.soundVolumes.getOrDefault(soundId, Float.valueOf(1.0f)).floatValue();
    }

    public void setVolume(SoundEvent soundEvent, float volume) {
        if (soundEvent == null) {
            return;
        }
        this.setVolume(soundEvent.m_11660_(), volume);
    }

    public void setVolume(ResourceLocation soundId, float volume) {
        float clampedVolume = Math.max(0.0f, Math.min(1.0f, volume));
        Float oldVolume = this.soundVolumes.put(soundId, Float.valueOf(clampedVolume));
        if (oldVolume == null || Math.abs(oldVolume.floatValue() - clampedVolume) > 0.001f) {
            this.isDirty = true;
        }
    }

    public Map<ResourceLocation, Float> getAllVolumes() {
        return this.soundVolumes;
    }

    public void load() {
        try {
            block20: {
                Path configPath = this.getConfigFile();
                if (!Files.exists(configPath, new LinkOption[0])) {
                    LOGGER.info("No vault sound options file found, using defaults");
                    try (BufferedWriter writer = Files.newBufferedWriter(configPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                        writer.write("# Vault Sound Options\n");
                        writer.write("# Format: sound_id:volume\n");
                    }
                    return;
                }
                this.soundVolumes.clear();
                BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);
                block14: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int lastColonIndex;
                        if (line.isEmpty() || line.startsWith("#") || (lastColonIndex = line.lastIndexOf(58)) == -1) continue;
                        String soundIdStr = line.substring(0, lastColonIndex);
                        String volumeStr = line.substring(lastColonIndex + 1);
                        try {
                            ResourceLocation soundId = new ResourceLocation(soundIdStr);
                            float volume = Float.parseFloat(volumeStr);
                            this.soundVolumes.put(soundId, Float.valueOf(Math.max(0.0f, Math.min(1.0f, volume))));
                            continue block14;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Invalid line in vault sound options: {}", (Object)line);
                            e.printStackTrace();
                        }
                    }
                    break block20;
                    {
                        continue block14;
                        break;
                    }
                    break;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            LOGGER.info("Loaded {} vault sound options", (Object)this.soundVolumes.size());
            this.isDirty = false;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load vault sound options", (Throwable)e);
        }
    }

    public void save() {
        if (!this.isDirty) {
            return;
        }
        try {
            Path configPath = this.getConfigFile();
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("# Vault Sound Options\n");
                writer.write("# Format: sound_id:volume\n");
                for (Map.Entry<ResourceLocation, Float> entry : this.soundVolumes.entrySet()) {
                    writer.write(entry.getKey().toString());
                    writer.write(58);
                    writer.write(Float.toString(entry.getValue().floatValue()));
                    writer.newLine();
                }
            }
            this.isDirty = false;
            LOGGER.info("Saved vault sound options");
        }
        catch (Exception e) {
            LOGGER.error("Failed to save vault sound options", (Throwable)e);
        }
    }

    private Path getConfigFile() {
        return Minecraft.m_91087_().f_91069_.toPath().resolve(CONFIG_FILENAME);
    }
}

