/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.atlas;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;

public class AtlasBufferPosColorTex {
    private final BufferBuilder builder;

    public AtlasBufferPosColorTex(BufferBuilder builder) {
        this.builder = builder;
    }

    public BufferBuilder getBuilder() {
        return this.builder;
    }

    public void begin(VertexFormat.Mode mode, VertexFormat format) {
        this.builder.m_166779_(mode, format);
    }

    public void end() {
        this.builder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)this.builder);
    }

    public void add(Matrix4f matrix4f, int x, int y, TextureAtlasSprite sprite) {
        this.add(matrix4f, x, y, 0, sprite.m_118405_(), sprite.m_118408_(), 1.0f, 1.0f, 1.0f, 1.0f, sprite);
    }

    public void add(Matrix4f matrix4f, int x, int y, int z, TextureAtlasSprite sprite) {
        this.add(matrix4f, x, y, z, sprite.m_118405_(), sprite.m_118408_(), 1.0f, 1.0f, 1.0f, 1.0f, sprite);
    }

    public void add(Matrix4f matrix4f, int x, int y, float r, float g, float b, float a, TextureAtlasSprite sprite) {
        this.add(matrix4f, x, y, 0, sprite.m_118405_(), sprite.m_118408_(), r, g, b, a, sprite);
    }

    public void add(Matrix4f matrix4f, int x, int y, int z, float r, float g, float b, float a, TextureAtlasSprite sprite) {
        this.add(matrix4f, x, y, z, sprite.m_118405_(), sprite.m_118408_(), r, g, b, a, sprite);
    }

    public void add(Matrix4f matrix4f, int x, int y, int z, int width, int height, float r, float g, float b, float a, TextureAtlasSprite sprite) {
        this.builder.m_85982_(matrix4f, (float)x, (float)(y + height), (float)z).m_85950_(r, g, b, a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        this.builder.m_85982_(matrix4f, (float)(x + width), (float)(y + height), (float)z).m_85950_(r, g, b, a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        this.builder.m_85982_(matrix4f, (float)(x + width), (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        this.builder.m_85982_(matrix4f, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
    }

    public void addBounded(Matrix4f matrix4f, int x, int y, int z, int width, int height, float r, float g, float b, float a, TextureAtlasSprite sprite, Bounds bounds) {
        if (Mth.m_14033_((float)bounds.minX, (float)bounds.maxX) || Mth.m_14033_((float)bounds.minY, (float)bounds.maxY)) {
            return;
        }
        if ((float)x > bounds.maxX || (float)(x + width) < bounds.minX || (float)y > bounds.maxY || (float)(y + height) < bounds.minY) {
            return;
        }
        float du = sprite.m_118410_() - sprite.m_118409_();
        float dv = sprite.m_118412_() - sprite.m_118411_();
        float x0 = Math.max((float)x, bounds.minX);
        float x1 = Math.min((float)(x + width), bounds.maxX);
        float y0 = Math.max((float)y, bounds.minY);
        float y1 = Math.min((float)(y + height), bounds.maxY);
        float u0 = (x0 - (float)x) / (float)width * du + sprite.m_118409_();
        float u1 = u0 + (x1 - x0) / (float)width * du;
        float v0 = (y0 - (float)y) / (float)height * dv + sprite.m_118411_();
        float v1 = v0 + (y1 - y0) / (float)height * dv;
        this.builder.m_85982_(matrix4f, x0, y1, (float)z).m_85950_(r, g, b, a).m_7421_(u0, v1).m_5752_();
        this.builder.m_85982_(matrix4f, x1, y1, (float)z).m_85950_(r, g, b, a).m_7421_(u1, v1).m_5752_();
        this.builder.m_85982_(matrix4f, x1, y0, (float)z).m_85950_(r, g, b, a).m_7421_(u1, v0).m_5752_();
        this.builder.m_85982_(matrix4f, x0, y0, (float)z).m_85950_(r, g, b, a).m_7421_(u0, v0).m_5752_();
    }

    public static final class Bounds {
        float minX;
        float minY;
        float maxX;
        float maxY;

        public Bounds() {
            this.set(0.0f, 0.0f, 0.0f, 0.0f);
        }

        public Bounds(float minX, float minY, float maxX, float maxY) {
            this.set(minX, minY, maxX, maxY);
        }

        public Bounds set(float minX, float minY, float maxX, float maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
            return this;
        }
    }
}

