/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.atlas;

import iskallia.vault.VaultMod;
import iskallia.vault.client.atlas.AbstractTextureAtlasHolder;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ResourceTextureAtlasHolder
extends AbstractTextureAtlasHolder {
    protected final ResourceManager resourceManager;
    protected final ResourceLocation resourceLocation;

    public ResourceTextureAtlasHolder(TextureManager textureManager, ResourceManager resourceManager, ResourceLocation atlasResourceLocation, ResourceLocation resourceLocation) {
        super(textureManager, atlasResourceLocation);
        this.resourceManager = resourceManager;
        this.resourceLocation = resourceLocation;
        textureManager.m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    public ResourceTextureAtlasHolder(TextureManager textureManager, ResourceManager resourceManager, ResourceLocation atlasResourceLocation, ResourceLocation resourceLocation, Supplier<List<ResourceLocation>> validationSupplier) {
        super(textureManager, atlasResourceLocation, validationSupplier);
        this.resourceManager = resourceManager;
        this.resourceLocation = resourceLocation;
        textureManager.m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    @Override
    @Nonnull
    protected Stream<ResourceLocation> getResourcesToLoad() {
        try {
            return this.resourceManager.m_6540_(this.resourceLocation.m_135815_(), this::isValidResource).stream().filter(this::filterResourceLocation).map(this::sanitizeResourceLocation);
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Error gathering texture atlas resources", (Throwable)e);
            return Stream.empty();
        }
    }

    protected boolean filterResourceLocation(ResourceLocation resourceLocation) {
        return this.resourceLocation.m_135827_().equals(resourceLocation.m_135827_());
    }

    protected boolean isValidResource(String resourceString) {
        return ResourceLocation.m_135830_((String)resourceString) && resourceString.endsWith(".png");
    }
}

