/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.animation.KeyframeAnimation;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.util.Tween;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ElementAnimator {
    private final Map<String, KeyframeAnimation> animations = new HashMap<String, KeyframeAnimation>();
    private float time;
    private float duration;
    private boolean playing;
    private Playback playback = Playback.PLAY_ONCE;
    private boolean pingPongForward = true;
    private boolean backwards = false;

    public ElementAnimator() {
        this(false);
    }

    public ElementAnimator(boolean defaultPlaying) {
        this(defaultPlaying, Playback.PLAY_ONCE);
    }

    public ElementAnimator(boolean defaultPlaying, Playback playback) {
        this.playing = defaultPlaying;
        this.playback = playback;
        this.time = 0.0f;
        this.duration = 0.0f;
    }

    public ElementAnimator setPlayback(Playback playback) {
        this.playback = playback;
        return this;
    }

    public ElementAnimator addFrame(Property property, float time, float value, Tween easing) {
        KeyframeAnimation anim = this.animations.computeIfAbsent(property.name(), k -> new KeyframeAnimation());
        return this.addFrame(property.name(), time, value, easing);
    }

    public ElementAnimator addFrame(String key, float time, float value, Tween easing) {
        KeyframeAnimation anim = this.animations.computeIfAbsent(key, k -> new KeyframeAnimation());
        anim.addFrame(time, value, easing);
        this.duration = Math.max(this.duration, anim.getDuration());
        return this;
    }

    public ElementAnimator addPositionKeyframe(float time, IPosition pos, Tween easing) {
        this.addFrame(Property.X, time, (float)pos.x(), easing);
        this.addFrame(Property.Y, time, (float)pos.y(), easing);
        return this;
    }

    public ElementAnimator addUniformScaleKeyframe(float time, float scale, Tween easing) {
        this.addFrame(Property.SCALE_X, time, scale, easing);
        this.addFrame(Property.SCALE_Y, time, scale, easing);
        return this;
    }

    public void start() {
        this.playing = true;
        this.time = 0.0f;
        this.pingPongForward = true;
    }

    public void pause() {
        this.playing = false;
    }

    public void stop() {
        this.playing = false;
        this.time = this.duration;
        this.pingPongForward = true;
    }

    public void tick(float delta) {
        if (!this.playing || this.duration <= 0.0f) {
            return;
        }
        switch (this.playback) {
            case LOOP: {
                this.time += delta;
                if (!(this.time > this.duration)) break;
                this.time %= this.duration;
                break;
            }
            case HOLD_ON_LAST_FRAME: {
                this.time = Math.min(this.time + delta, this.duration);
                break;
            }
            case PING_PONG: {
                this.time += this.pingPongForward ? delta : -delta;
                if (this.time >= this.duration) {
                    this.time = this.duration;
                    this.pingPongForward = false;
                    break;
                }
                if (!(this.time <= 0.0f)) break;
                this.time = 0.0f;
                this.pingPongForward = true;
                break;
            }
            default: {
                this.time += delta;
                if (!(this.time >= this.duration)) break;
                this.time = this.duration;
                this.playing = false;
            }
        }
    }

    public float get(Property property) {
        return this.get(property.name());
    }

    public float get(String key) {
        KeyframeAnimation animation = this.animations.get(key);
        if (animation == null) {
            return -1.0f;
        }
        return animation.evaluate(this.time, this.backwards);
    }

    public float get(Property property, float delay) {
        return this.get(property.name(), delay);
    }

    public float get(String key, float delay) {
        KeyframeAnimation animation = this.animations.get(key);
        if (animation == null) {
            return -1.0f;
        }
        this.duration = Math.max(this.duration, animation.getDuration() + delay);
        return animation.evaluate(this.time - delay, this.backwards);
    }

    public boolean isFinished() {
        return switch (this.playback) {
            case Playback.LOOP, Playback.PING_PONG -> false;
            default -> this.time >= this.duration;
        };
    }

    public float getTime() {
        return this.time;
    }

    public void apply(@NotNull PoseStack poseStack) {
        poseStack.m_85837_((double)this.get(Property.X), (double)this.get(Property.Y), 0.0);
    }

    public ElementAnimator backwards() {
        this.backwards = true;
        return this;
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public ElementAnimator backwards(boolean backwards) {
        this.backwards = backwards;
        return this;
    }

    public static enum Playback {
        PLAY_ONCE,
        LOOP,
        HOLD_ON_LAST_FRAME,
        PING_PONG;

    }

    public static enum Property {
        X,
        Y,
        WIDTH,
        HEIGHT,
        ROTATION,
        OPACITY,
        SCALE_X,
        SCALE_Y;

    }
}

