/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.animation;

import iskallia.vault.client.gui.animation.Keyframe;
import iskallia.vault.util.Tween;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class KeyframeAnimation {
    private final List<Keyframe> keyframes = new ArrayList<Keyframe>();
    private float duration = 0.0f;

    public KeyframeAnimation addFrame(float time, float value, Tween easing) {
        this.keyframes.add(new Keyframe(time, value, easing));
        this.duration = Math.max(this.duration, time);
        this.keyframes.sort(Comparator.comparing(Keyframe::getTime));
        return this;
    }

    public float getDuration() {
        return this.duration;
    }

    public float evaluate(float t) {
        return this.evaluate(t, false);
    }

    public float evaluate(float t, boolean inverted) {
        if (this.keyframes.isEmpty()) {
            return 0.0f;
        }
        if (t <= this.keyframes.get(0).getTime()) {
            return inverted ? this.keyframes.get(this.keyframes.size() - 1).getValue() : this.keyframes.get(0).getValue();
        }
        for (int i = 0; i < this.keyframes.size() - 1; ++i) {
            Keyframe start = this.keyframes.get(i);
            Keyframe end = this.keyframes.get(i + 1);
            if (!(t >= start.getTime()) || !(t <= end.getTime())) continue;
            float progress = t - start.getTime();
            float delta = inverted ? start.getValue() - end.getValue() : end.getValue() - start.getValue();
            float d = end.getTime() - start.getTime();
            float baseValue = inverted ? end.getValue() : start.getValue();
            return start.getEasing().tween(progress, baseValue, delta, d);
        }
        return inverted ? this.keyframes.get(0).getValue() : this.keyframes.get(this.keyframes.size() - 1).getValue();
    }
}

