/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.component.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.bounty.TaskRegistry;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class BountyToast
implements Toast {
    private static final ResourceLocation BOUNTY_TEXTURE = VaultMod.id("textures/gui/screen/bounty/toasts.png");
    private static final Map<ResourceLocation, int[]> uvCoordinates = Map.of(TaskRegistry.KILL_ENTITY, new int[]{0, 32}, TaskRegistry.DAMAGE_ENTITY, new int[]{32, 32}, TaskRegistry.COMPLETION, new int[]{64, 32}, TaskRegistry.ITEM_DISCOVERY, new int[]{96, 32}, TaskRegistry.ITEM_SUBMISSION, new int[]{128, 32}, TaskRegistry.MINING, new int[]{160, 32}, VaultMod.id("unidentified"), new int[]{192, 32});
    private static final long DISPLAY_TIME = 3000L;
    private final Component title;
    private final List<FormattedCharSequence> message;
    private long deltaTime;
    private boolean changed;
    private ResourceLocation taskId;

    private BountyToast(Component title, Component message, ResourceLocation taskId) {
        this.title = title;
        this.message = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)message, 122);
        this.taskId = taskId;
    }

    public static void add(Component title, Component message, ResourceLocation taskId) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new BountyToast(title, message, taskId));
    }

    @NotNull
    public Toast.Visibility m_7172_(@NotNull PoseStack poseStack, @NotNull ToastComponent toastComponent, long deltaTime) {
        if (this.changed) {
            this.deltaTime = deltaTime;
            this.changed = false;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BOUNTY_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.message.size() <= 1) {
            toastComponent.m_93228_(poseStack, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        } else {
            int lineHeight = 12;
            int messageHeight = this.m_94899_() + Math.max(0, this.message.size() - 1) * lineHeight;
            int startY = 18;
            toastComponent.m_93228_(poseStack, 0, 0, 0, 0, this.m_7828_(), startY);
            for (int y = 0; y < this.message.size(); ++y) {
                toastComponent.m_93228_(poseStack, 0, startY + y * lineHeight, 0, lineHeight, this.m_7828_(), lineHeight);
            }
            toastComponent.m_93228_(poseStack, 0, messageHeight - 4, 0, 28, this.m_7828_(), 4);
        }
        toastComponent.m_93228_(poseStack, 2, 6, uvCoordinates.get(this.taskId)[0], uvCoordinates.get(this.taskId)[1], 32, 32);
        toastComponent.m_94929_().f_91062_.m_92889_(poseStack, this.title, 36.0f, 7.0f, Color.WHITE.getRGB());
        int messageY = 20;
        for (FormattedCharSequence formattedCharSequence : this.message) {
            toastComponent.m_94929_().f_91062_.m_92877_(poseStack, formattedCharSequence, 36.0f, (float)messageY, Color.LIGHT_GRAY.getRGB());
            messageY += 12;
        }
        return deltaTime - this.deltaTime >= 3000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

