/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.component.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GenericToast
implements Toast {
    private static final ResourceLocation TOAST_BACKGROUND = VaultMod.id("textures/gui/screen/toast_background.png");
    protected final Component title;
    protected final List<FormattedCharSequence> message;
    protected final ResourceLocation texture;

    public GenericToast(Component title, Component message, ResourceLocation texture) {
        this.title = title;
        this.message = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)message, 120);
        this.texture = this.parseTexture(texture);
    }

    private ResourceLocation parseTexture(ResourceLocation texture) {
        Object path = texture.m_135815_();
        if (((String)path).startsWith("textures")) {
            return texture;
        }
        path = "textures/" + (String)path + ".png";
        return new ResourceLocation(texture.m_135827_(), (String)path);
    }

    protected long getDisplayTime() {
        return 3000L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void add(String title, String message, ResourceLocation icon) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new GenericToast((Component)new TextComponent(title), (Component)new TextComponent(message), icon));
    }

    @NotNull
    public Toast.Visibility m_7172_(@NotNull PoseStack poseStack, @NotNull ToastComponent toastComponent, long deltaTime) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOAST_BACKGROUND);
        int startY = 4;
        toastComponent.m_93228_(poseStack, 0, 0, 0, 0, this.m_7828_(), startY);
        for (int y = 0; y < this.m_94899_() - 8; ++y) {
            toastComponent.m_93228_(poseStack, 0, startY + y, 0, 4, this.m_7828_(), 1);
        }
        toastComponent.m_93228_(poseStack, 0, this.m_94899_() - 4, 0, 30, this.m_7828_(), 4);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)10, (int)8, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        toastComponent.m_94929_().f_91062_.m_92889_(poseStack, this.title, 36.0f, 7.0f, Color.WHITE.getRGB());
        int messageY = 20;
        for (FormattedCharSequence formattedCharSequence : this.message) {
            toastComponent.m_94929_().f_91062_.m_92877_(poseStack, formattedCharSequence, 36.0f, (float)messageY, Color.LIGHT_GRAY.getRGB());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            messageY += 9;
        }
        return deltaTime >= this.getDisplayTime() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public int m_94899_() {
        int n = this.message.size();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 34 + n * 9;
    }
}

