/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.atlas.AtlasMultiBuffer;
import iskallia.vault.client.gui.framework.render.ClipRegionStrategies;
import iskallia.vault.client.gui.framework.render.DebugRenderer;
import iskallia.vault.client.gui.framework.render.ElementRenderers;
import iskallia.vault.client.gui.framework.render.spi.IDebugRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.init.ModTextureAtlases;
import net.minecraftforge.common.util.LazyOptional;

public final class ScreenRenderers {
    private static final LazyOptional<AtlasMultiBuffer> BUFFERED = LazyOptional.of(() -> AtlasMultiBuffer.builder().add(ModTextureAtlases.SCREEN, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.SCAVENGER, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.MODIFIERS, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.MOB_HEADS, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.QUESTS, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.ABILITIES, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.SKILLS, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.PRESTIGE, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.TITLE, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.MOB_GROUPS, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.VAULT_MAP, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).add(ModTextureAtlases.INVENTORY_HUD, VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_).create());
    private static final LazyOptional<BufferBuilder> DEBUG_BUFFERED = LazyOptional.of(() -> new BufferBuilder(256));

    public static IElementRenderer getBuffered() {
        return (IElementRenderer)BUFFERED.map(buffer -> ElementRenderers.bufferedPosTex(buffer, ClipRegionStrategies.STENCIL)).orElseThrow(() -> new RuntimeException("Error creating buffered screen renderer"));
    }

    public static IElementRenderer getImmediate() {
        return ElementRenderers.immediate(ClipRegionStrategies.STENCIL);
    }

    public static IDebugRenderer getDebugNone() {
        return IDebugRenderer.NONE;
    }

    public static IDebugRenderer getDebugBuffered() {
        return (IDebugRenderer)DEBUG_BUFFERED.map(DebugRenderer::new).orElseThrow(() -> new RuntimeException("Error creating debug buffer"));
    }

    private ScreenRenderers() {
    }
}

