/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.screen.block.VaultJewelApplicationStationScreen;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;
import org.jetbrains.annotations.NotNull;

public class ClickableItemSlotElement<E extends ClickableItemSlotElement<E>>
extends ElasticContainerElement<E> {
    protected TextureAtlasRegion slotTexture;
    protected TextureAtlasRegion overlayTexture;
    protected TextureAtlasRegion disabledSlotTexture;
    protected Supplier<ItemStack> itemStack;
    protected Supplier<Boolean> disabled;
    protected boolean ignoreGlint;
    protected Runnable onClickHandler;
    protected Supplier<Component> labelSupplier = () -> null;

    public ClickableItemSlotElement(ISpatial spatial) {
        this(spatial, () -> ItemStack.f_41583_, () -> false);
    }

    public ClickableItemSlotElement(ISpatial spatial, Supplier<ItemStack> itemStack, Supplier<Boolean> disabled) {
        this(spatial, itemStack, disabled, ScreenTextures.INSET_ITEM_SLOT_BACKGROUND, ScreenTextures.INSET_DISABLED_ITEM_SLOT_BACKGROUND);
    }

    public ClickableItemSlotElement(ISpatial spatial, Supplier<ItemStack> itemStack, Supplier<Boolean> disabled, TextureAtlasRegion slotTexture, TextureAtlasRegion disabledSlotTexture) {
        this(spatial, itemStack, disabled, slotTexture, disabledSlotTexture, slotTexture.width(), slotTexture.height());
    }

    public ClickableItemSlotElement(ISpatial spatial, Supplier<ItemStack> itemStack, Supplier<Boolean> disabled, TextureAtlasRegion slotTexture, TextureAtlasRegion disabledSlotTexture, int width, int height) {
        super(Spatials.copy(spatial).size(width, height));
        this.itemStack = itemStack;
        this.slotTexture = slotTexture;
        this.disabledSlotTexture = disabledSlotTexture;
        this.disabled = disabled;
    }

    public ClickableItemSlotElement<E> whenClicked(Runnable onClickHandler) {
        this.onClickHandler = onClickHandler;
        return this;
    }

    public ClickableItemSlotElement<E> setLabel(Supplier<Component> countLabelSupplier) {
        this.labelSupplier = countLabelSupplier;
        return this;
    }

    public void setItemStack(Supplier<ItemStack> sup) {
        this.itemStack = sup;
    }

    public ClickableItemSlotElement<E> setLabelStackCount() {
        this.labelSupplier = () -> {
            ItemStack stack = this.getDisplayStack();
            if (stack.m_41619_() || stack.m_41613_() <= 1) {
                return null;
            }
            return new TextComponent(String.valueOf(stack.m_41613_()));
        };
        return this;
    }

    public ClickableItemSlotElement<E> ignoringGlint() {
        this.ignoreGlint = true;
        return this;
    }

    public ClickableItemSlotElement<E> overlayTexture(TextureAtlasRegion overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public void setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public ItemStack getDisplayStack() {
        return this.itemStack.get();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        if (!this.isDisabled() && this.onClickHandler != null) {
            Runnable runnable = this.onClickHandler;
            if (runnable instanceof VaultJewelApplicationStationScreen.MouseClickRunnable) {
                VaultJewelApplicationStationScreen.MouseClickRunnable mouseClickRunnable = (VaultJewelApplicationStationScreen.MouseClickRunnable)runnable;
                mouseClickRunnable.setType(buttonIndex);
            }
            this.onClickHandler.run();
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, buttonIndex);
    }

    @Override
    public boolean onHoverTooltip(ITooltipRenderer tooltipRenderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        if (!this.containsMouse(mouseX, mouseY)) {
            return false;
        }
        return super.onHoverTooltip(tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag);
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int buttonIndex) {
        return true;
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        if (this.isDisabled()) {
            renderer.render(this.disabledSlotTexture, poseStack, (IPosition)this.worldSpatial);
        } else {
            renderer.render(this.slotTexture, poseStack, (IPosition)this.worldSpatial);
        }
        if (this.overlayTexture != null) {
            renderer.render(this.overlayTexture, poseStack, (IPosition)this.worldSpatial.copy().translateXY(1, 1));
        }
        this.renderItemStack(this.getDisplayStack(), this.worldSpatial.x() + 1, this.worldSpatial.y() + 1, this.isDisabled());
        this.renderLabel(this.getDisplayStack(), poseStack);
        if (this.containsMouse(mouseX, mouseY)) {
            ClickableItemSlotElement.renderSlotHighlight(poseStack, this.worldSpatial.x() + 1, this.worldSpatial.y() + 1, 20, -2130706433);
        }
    }

    @Override
    public boolean containsMouse(double x, double y) {
        return x < (double)this.right() && x >= (double)this.left() && y >= (double)this.top() && y < (double)this.bottom();
    }

    public static void renderSlotHighlight(PoseStack pPoseStack, int pX, int pY, int pBlitOffset, int slotColor) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        ClickableItemSlotElement.fillGradient(pPoseStack, pX, pY, pX + 16, pY + 16, slotColor, slotColor, pBlitOffset);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    protected static void fillGradient(PoseStack pPoseStack, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        ClickableItemSlotElement.fillGradient(pPoseStack.m_85850_().m_85861_(), bufferbuilder, pX1, pY1, pX2, pY2, pBlitOffset, pColorFrom, pColorTo);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    protected static void fillGradient(Matrix4f pMatrix, BufferBuilder pBuilder, int pX1, int pY1, int pX2, int pY2, int pBlitOffset, int pColorA, int pColorB) {
        float f = (float)(pColorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(pColorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(pColorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(pColorA & 0xFF) / 255.0f;
        float f4 = (float)(pColorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(pColorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(pColorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(pColorB & 0xFF) / 255.0f;
        pBuilder.m_85982_(pMatrix, (float)pX2, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX1, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX1, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX2, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    protected void renderLabel(ItemStack stack, PoseStack poseStack) {
        String lblStr = "";
        Component label = this.labelSupplier.get();
        if (label != null && !label.getString().isEmpty()) {
            lblStr = label.getString();
        }
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        Font font = Minecraft.m_91087_().f_91062_;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)(this.worldSpatial.z() + 400));
        PoseStack modelStack = RenderSystem.m_157191_();
        modelStack.m_85836_();
        modelStack.m_166854_(poseStack.m_85850_().m_85861_());
        RenderSystem.m_157182_();
        renderer.m_115174_(font, stack, this.worldSpatial.x() + 1, this.worldSpatial.y() + 1, lblStr);
        modelStack.m_85849_();
        RenderSystem.m_157182_();
        poseStack.m_85849_();
        RenderSystem.m_69482_();
    }

    protected void renderItemStack(ItemStack itemStack, float x, float y, boolean disabled) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        PoseStack poseStack2 = new PoseStack();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, 350.0);
        posestack.m_85837_(8.0, 8.0, 8.0);
        posestack.m_85841_(16.0f, -16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        if (disabled) {
            Lighting.m_84931_();
        } else {
            Lighting.m_84930_();
        }
        this.renderItemStack(itemStack, ItemTransforms.TransformType.GUI, false, poseStack2, (MultiBufferSource)bufferSource, LightmapHelper.getPackedFullbrightCoords(), OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private void renderItemStack(ItemStack pItemStack, ItemTransforms.TransformType pTransformType, boolean pLeftHand, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay, BakedModel pModel) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        ItemModelShaper itemModelShaper = itemRenderer.m_115103_();
        if (!pItemStack.m_41619_()) {
            boolean flag;
            pMatrixStack.m_85836_();
            boolean bl = flag = pTransformType == ItemTransforms.TransformType.GUI || pTransformType == ItemTransforms.TransformType.GROUND || pTransformType == ItemTransforms.TransformType.FIXED;
            if (flag) {
                if (pItemStack.m_150930_(Items.f_42713_)) {
                    pModel = itemModelShaper.m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
                } else if (pItemStack.m_150930_(Items.f_151059_)) {
                    pModel = itemModelShaper.m_109393_().m_119422_(new ModelResourceLocation("minecraft:spyglass#inventory"));
                }
            }
            pModel = ForgeHooksClient.handleCameraTransforms((PoseStack)pMatrixStack, (BakedModel)pModel, (ItemTransforms.TransformType)pTransformType, (boolean)pLeftHand);
            pMatrixStack.m_85837_(-0.5, -0.5, -0.5);
            if (!(pModel.m_7521_() || pItemStack.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = pTransformType != ItemTransforms.TransformType.GUI && !pTransformType.m_111841_() && pItemStack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)pItemStack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (pModel.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)itemRenderer, (BakedModel)pModel, (ItemStack)pItemStack, (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pCombinedLight, (int)pCombinedOverlay, (boolean)flag1);
                } else {
                    VertexConsumer vertexconsumer;
                    RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)pItemStack, (boolean)flag1);
                    if (pItemStack.m_150930_(Items.f_42522_) && pItemStack.m_41790_()) {
                        pMatrixStack.m_85836_();
                        PoseStack.Pose posestack$pose = pMatrixStack.m_85850_();
                        if (pTransformType == ItemTransforms.TransformType.GUI) {
                            posestack$pose.m_85861_().m_27630_(0.5f);
                        } else if (pTransformType.m_111841_()) {
                            posestack$pose.m_85861_().m_27630_(0.75f);
                        }
                        vertexconsumer = flag1 ? ClickableItemSlotElement.getCompassFoilBufferDirect(pBuffer, rendertype, posestack$pose) : ClickableItemSlotElement.getCompassFoilBuffer(pBuffer, rendertype, posestack$pose);
                        pMatrixStack.m_85849_();
                    } else {
                        vertexconsumer = flag1 ? ClickableItemSlotElement.getFoilBufferDirect(pBuffer, rendertype, true, !this.ignoreGlint && pItemStack.m_41790_()) : ClickableItemSlotElement.getFoilBuffer(pBuffer, rendertype, true, !this.ignoreGlint && pItemStack.m_41790_());
                    }
                    itemRenderer.m_115189_(pModel, pItemStack, pCombinedLight, pCombinedOverlay, pMatrixStack, vertexconsumer);
                }
            } else {
                RenderProperties.get((ItemStack)pItemStack).getItemStackRenderer().m_108829_(pItemStack, pTransformType, pMatrixStack, pBuffer, pCombinedLight, pCombinedOverlay);
            }
            pMatrixStack.m_85849_();
        }
    }

    public static VertexConsumer getCompassFoilBuffer(MultiBufferSource pBuffer, RenderType pRenderType, PoseStack.Pose pMatrixEntry) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(pBuffer.m_6299_(RenderType.m_110490_()), pMatrixEntry.m_85861_(), pMatrixEntry.m_85864_()), (VertexConsumer)pBuffer.m_6299_(pRenderType));
    }

    public static VertexConsumer getCompassFoilBufferDirect(MultiBufferSource pBuffer, RenderType pRenderType, PoseStack.Pose pMatrixEntry) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(pBuffer.m_6299_(RenderType.m_110493_()), pMatrixEntry.m_85861_(), pMatrixEntry.m_85864_()), (VertexConsumer)pBuffer.m_6299_(pRenderType));
    }

    public static VertexConsumer getFoilBuffer(MultiBufferSource pBuffer, RenderType pRenderType, boolean pIsItem, boolean pGlint) {
        if (pGlint) {
            return Minecraft.m_91085_() && pRenderType == Sheets.m_110791_() ? VertexMultiConsumer.m_86168_((VertexConsumer)pBuffer.m_6299_(RenderType.m_110487_()), (VertexConsumer)pBuffer.m_6299_(pRenderType)) : VertexMultiConsumer.m_86168_((VertexConsumer)pBuffer.m_6299_(pIsItem ? RenderType.m_110490_() : RenderType.m_110496_()), (VertexConsumer)pBuffer.m_6299_(pRenderType));
        }
        return pBuffer.m_6299_(pRenderType);
    }

    public static VertexConsumer getFoilBufferDirect(MultiBufferSource pBuffer, RenderType pRenderType, boolean pNoEntity, boolean pWithGlint) {
        return pWithGlint ? VertexMultiConsumer.m_86168_((VertexConsumer)pBuffer.m_6299_(pNoEntity ? RenderType.m_110493_() : RenderType.m_110499_()), (VertexConsumer)pBuffer.m_6299_(pRenderType)) : pBuffer.m_6299_(pRenderType);
    }
}

